\name{metrics-methods}
\docType{methods}

\alias{metrics}
\alias{metrics,beadLevelData-method}
\alias{p95}
\alias{p95,beadLevelData,character-method}
\alias{snr}
\alias{snr,beadLevelData,character-method}

\title{Accessing metrics information in bead-level objects}

\description{
The \code{metrics}, \code{p95} and \code{snr} methods conveniently access metrics information that is stored in a beadLevelData object. These data are generated by the Illumina scanning software and can be an early indicator of array quality. These include the 95th (P95) and 5th (P05) quantiles of all pixel intensities on the image. A signal-to-noise ratio (SNR) can be calculated as the ratio of these two quantities. These metrics can be viewed in real-time as the arrays themselves are being scanned. By tracking these metrics over time, one can potentially halt problematic experiments before they even reach the analysis stage. Illumina recommend that the SNR ratio should be above 10, so these arrays are acceptable. However, the P95 and P05 values will fluctuate over time and are dependant upon the scanner setup. Including SNR values for arrays other than those currently being analysed will give a better indication of whether any outlier arrays exist. 


}

\examples{
    if(require(beadarrayExampleData)){

        data(exampleBLData)

        metrics(exampleBLData)

        p95(exampleBLData, "Grn")

        snr(exampleBLData, "Grn")

    }
}

\author{Mark Dunning}

\keyword{methods}

