% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_bioc_github_action.R
\name{use_bioc_github_action}
\alias{use_bioc_github_action}
\title{Create a biocthis-style GitHub Actions workflow}
\usage{
use_bioc_github_action(
  biocdocker,
  pkgdown = getOption("biocthis.pkgdown", FALSE),
  testthat = getOption("biocthis.testthat", FALSE),
  covr = testthat,
  covr_coverage_type = getOption("biocthis.covr_coverage_type", "all"),
  RUnit = getOption("biocthis.RUnit", FALSE),
  pkgdown_covr_branch = getOption("biocthis.pkgdown_covr_branch", "devel"),
  docker = getOption("biocthis.docker", FALSE)
)
}
\arguments{
\item{biocdocker}{A \code{character(1)} specifying the Bioconductor docker
version you want to use. Valid names are \code{"devel"} or in the
\code{"RELEASE_X_Y"} format such as \code{"RELEASE_3_11"}. Check
\url{http://bioconductor.org/help/docker/} for more information on the
Bioconductor docker images. If you don't specify this, it will be
determined automatically using your current Bioconductor version. The
R version will be set to match the Bioconductor version.}

\item{pkgdown}{A \code{logical(1)} specifying whether to run \code{pkgdown}. Check
\url{https://cran.r-project.org/web/packages/pkgdown/index.html} for more
information on \code{pkgdown} which is useful for creating documentation
websites. If \code{TRUE}, then \code{pkgdown} will only run on the Linux
(Bioconductor docker) test.}

\item{testthat}{A \code{logical(1)} specifying whether to run \code{testthat}. Check
\url{https://cran.r-project.org/web/packages/testthat/index.html} for more
information about \code{testthat} which is useful for unit tests. The
testing chapter at \url{https://r-pkgs.org/tests.html} is also very useful.}

\item{covr}{A \code{logical(1)} specifying whether to run \code{covr}. Check
\url{https://cran.r-project.org/web/packages/covr/index.html} for more
information about \code{covr}, which is useful for displaying for assessing
your test coverage. If \code{TRUE}, then \code{covr} will only run on the Linux
(Bioconductor docker) test.}

\item{covr_coverage_type}{A \code{character(1)} specifying the code used to
calculate the \code{covr} coverage. Option are package \code{"tests"}, \code{"vignettes"},
\code{"examples"}, \code{"all"}, or \code{"none"}. The default is \code{"all"}.}

\item{RUnit}{A \code{logical(1)} specifying whether to run \code{RUnit} unit tests.
Check \url{http://bioconductor.org/developers/how-to/unitTesting-guidelines/}
for more information about \code{RUnit}.}

\item{pkgdown_covr_branch}{A \code{character(1)} specifying the name of the GitHub
branch that will be used creating the \code{pkgdown} website and running \code{covr}.
Since biocthis version 1.9.3 this changed from "master" to "devel" by default
to match \url{https://twitter.com/Bioconductor/status/1631234299423850497}.}

\item{docker}{A \code{logical(1)} specifying whether to build a docker image
with the resulting package. This will also create a \code{Dockerfile}. You can
alternatively try using this excellent template:
\url{https://github.com/seandavi/BuildABiocWorkshop}.}
}
\value{
This function adds and/or replaces the
\code{.github/workflows/check-bioc.yml} file in your R package.
}
\description{
This function is very similar to \code{usethis::use_github_action()} except
that it uses a template from \code{biocthis}. It creates a Bioconductor-friendly
GitHub action workflow for your package. You can also use this GitHub
Actions workflow by executing \code{usethis::use_github_action()}.
}
\details{
For the full history on how this GitHub Actions workflow came to be, check
the "biocthis developer notes" vignette
\url{https://lcolladotor.github.io/biocthis/articles/biocthis_dev_notes.html}.
}
\examples{
\dontrun{
## Run this function in your package
biocthis::use_bioc_github_action()
}

## I have the following options on my ~/.Rprofile set
## Check
## <https://github.com/lcolladotor/biocthis/issues/9#issuecomment-702401032>
## for more information.
options("biocthis.pkgdown" = TRUE)
options("biocthis.testthat" = TRUE)
}
