% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_plot.R
\name{plotSimNetwork}
\alias{plotSimNetwork}
\title{Plot source and true differential networks from simulations}
\usage{
plotSimNetwork(
  simulation,
  what = c("source", "direct", "influence", "association"),
  ...
)
}
\arguments{
\item{simulation}{a list, storing data and results generated from simulations}

\item{what}{a character, indicating which network to retrieve, 'source'
(default), 'direct', 'influence' or 'association'}

\item{...}{additional parameters to \code{plot.igraph}}
}
\value{
a plot of the network
}
\description{
Plots either the source network or the true differential network
  for all KDs performed in the simulation. KD nodes are coloured with their
  resulting differential networks coloured accordingly.
}
\details{
The direct, influence and association networks represent different
  levels of true differential networks. The direct network contains
  differential regulatory interactions present in the original network. The
  influence network includes upstream interactions and the association
  network includes non-causative differential interactions.
}
\examples{
data(sim102)
plotSimNetwork(sim102)
plotSimNetwork(sim102, what = 'direct')
plotSimNetwork(sim102, what = 'influence')
plotSimNetwork(sim102, what = 'association')

}
\seealso{
\code{\link[igraph]{plot.igraph}}
}
