% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{plotDmmScatter}
\alias{plotDmmScatter}
\alias{plotDmmScatter,Demuxmix,missing-method}
\alias{plotDmmScatter,Demuxmix,ANY-method}
\title{Plotting RNA features versus HTO counts}
\usage{
plotDmmScatter(
  object,
  hto,
  log = TRUE,
  pointsize = 1.2,
  plotDecBoundary = TRUE,
  tol = 0.01
)
}
\arguments{
\item{object}{An object of class \code{\link{Demuxmix}}.}

\item{hto}{Optional vector specifying a subset of HTOs in \code{object} which
should be used by this function.}

\item{log}{Logical value indicating whether both HTO counts and number
of detected genes should be log transformed.}

\item{pointsize}{Numeric value specifying the size of the points.}

\item{plotDecBoundary}{Logical value indicating whether the decision
boundary should be added to the plot.}

\item{tol}{Numeric value between 0 and 1 specifying the error tolerance of
the decision boundary, i.e., a point on the plotted line has a posterior
probability within 0.5 +- \code{tol}. Only used of \code{plotDecBoundary}
is \code{true}.}
}
\value{
An object of class \code{ggplot} is returned, if only one HTO is
  plotted. If several HTOs are plotted simultaneously, a grid of plots is
  returned.
}
\description{
This methods plots the number of genes detected in a droplet versus the
number of sequenced HTOs. The posterior probability that the droplet is
positive for the HTO is indicated by a color gradient. Optionally, the
decision boundary with posterior probability 0.5 can be plotted. The mixture
model passed to this function must be a regression mixture model
generated by \code{\link{demuxmix}}.
}
\details{
The scatterplot produced by this method is helpful to assess
  the relation between the number of detected genes and the number
  of HTO counts obtained for a droplet. A positive association is usually
  visible for the positive cells (i.e., droplets with cells treated with the
  oligo-labeled antibodies). The association is often weak/absent in the
  droplets negative for the HTO.
  This method can only be applied to regression mixture models and not
  to naive mixture models. To see whether a \code{\link{Demuxmix}} object
  contains regression mixture models, type \code{show(object)} to display
  the type of model used for each HTO.
}
\examples{
set.seed(2642)
simdata <- dmmSimulateHto(class = rbind(c(rep(TRUE, 220), rep(FALSE, 200)),
                                        c(rep(FALSE, 200), rep(TRUE, 220))))

dmmreg <- demuxmix(simdata$hto, rna = simdata$rna, model = "reg")
\donttest{plotDmmScatter(dmmreg)}
\donttest{plotDmmScatter(dmmreg, hto = 1, log = FALSE)}

}
\seealso{
\code{\link{demuxmix}}
}
