% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc-geom-point.R
\name{geom_scattermore2}
\alias{geom_scattermore2}
\title{geom_scattermore2}
\usage{
geom_scattermore2(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  interpolate = FALSE,
  pointsize = 0,
  pixels = c(512, 512),
  gap_colour = "white",
  gap_alpha = 1,
  bg_line_width = 0.3,
  gap_line_width = 0.1
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{layer}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{interpolate}{A logical value indicating whether to linearly interpolate
the image (the alternative is to use nearest-neighbour interpolation,
which gives a more blocky result). Default \code{FALSE},
passed to \code{\link[grid]{rasterGrob}}.}

\item{pointsize}{Radius of rasterized point. Use ‘0’ for single pixels (fastest).}

\item{pixels}{Vector with X and Y resolution of the raster, default \code{c(512,512)}.}

\item{gap_colour}{colour of gap background between the bottom background
and top point point layer, default is \code{white}.}

\item{gap_alpha}{numeric the transparency of gap background colour, default is 1.}

\item{bg_line_width}{numeric the line width of background point layer,
default is \code{0.3}.}

\item{gap_line_width}{numeric the line width of gap between the background and
top point point layer, default is \code{.1}.}
}
\value{
polygonal point layer
}
\description{
this add the background colour for the \code{\link[scattermore]{geom_scattermore}}
}
\details{
\itemize{
\item \code{colour} the colour of point, default is \code{black}.
\item \code{bg_colour} the colour of background point, default is \code{NA}.
\item \code{alpha} the transparency of colour, default is 1.
\item \code{subset} subset the data frame which meet conditions to display.
}
}
\section{Aesthetics}{

\code{geom_scattermore2()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{\link[=aes_position]{x}}}
\item \strong{\code{\link[=aes_position]{y}}}
\item \code{\link[=aes_colour_fill_alpha]{alpha}}
\item \code{bg_colour}
\item \code{\link[=aes_colour_fill_alpha]{colour}}
\item \code{\link[=aes_colour_fill_alpha]{fill}}
\item \code{\link[=aes_group_order]{group}}
\item \code{\link[=aes_linetype_size_shape]{shape}}
\item \code{\link[=aes_linetype_size_shape]{size}}
\item \code{stroke}
\item \code{subset}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{
library(ggplot2)
ggplot(iris,
 aes(x= Sepal.Length, y = Petal.Width, color=Species, bg_colour=Species)
) + 
geom_scattermore2(pointsize=4, gap_line_width = .1, bg_line_width = .3)
}
\author{
Shuangbin Xu
}
