% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_lisa_feature}
\alias{plot_lisa_feature}
\title{plot_lisa_feature}
\usage{
plot_lisa_feature(
  spe,
  lisa.res,
  features = NULL,
  assay.type = "logcounts",
  geom = geom_bgpoint,
  pointsize = 2,
  hlpointsize = 1.8,
  clustertype = "High",
  hlcolor = c("black"),
  gap_line_width = 0.1,
  bg_line_width = 0.3,
  facet_name = NULL,
  reduction = NULL,
  image.plot = FALSE,
  label_wrap_width = 30,
  ...
)
}
\arguments{
\item{spe}{SpatialExperiment or SingleCellExperiment object.}

\item{lisa.res}{the result returned by \code{SVP::runLISA()}.}

\item{features}{selected features to be visualized, default is NULL.}

\item{assay.type}{the assay name where data will be used from
(e.g., 'data', 'counts'), default is \code{'logcounts'}.}

\item{geom}{the function of geometric layer, default is \code{geom_bgpoint},
other option is \code{sc_geom_point}.}

\item{pointsize}{numeric the size of point, default is \code{2}.}

\item{hlpointsize}{numeric the size of point which contains corresbonding
spatially variable gene(i.e., SVG), default is \code{1.8}.}

\item{clustertype}{cell type which is from the result of \code{lisa.res},
default is \code{'High'}.}

\item{hlcolor}{the color of circular line which enfolds the point
that contains SVG, default is \code{'black'}.}

\item{gap_line_width}{numeric the line width of gap between the background and
top point point layer, default is \code{.1}.}

\item{bg_line_width}{numeric the line width of background point layer,
default is \code{0.3}.}

\item{facet_name}{the name of facet used in \code{facet_wrap()},
default is \code{NULL}.}

\item{reduction}{reduction method, default is \code{NULL} and will
use the default setting store in the object}

\item{image.plot}{logical whether display the image of spatial experiment, default
is FALSE.}

\item{label_wrap_width}{numeric maximum number of characters before wrapping the strip.
default is \code{30}.}

\item{...}{additional parameters pass to \code{scattermore::geom_scattermore()}
\itemize{
\item \code{bg_colour} the colour of background point, default is \code{NA}.
this character also can be set in \code{mappint}.
\item \code{alpha} the transparency of colour, default is 1.
}}
}
\value{
ggplot object
}
\description{
plot_lisa_feature
}
\examples{
\dontrun{
library(ggplot2)
library(SingleCellExperiment) |> suppressPackageStartupMessages()
library(SpatialExperiment) |> suppressPackageStartupMessages()
library(STexampleData)
# create ExperimentHub instance
eh <- ExperimentHub()
# query STexampleData datasets
myfiles <- query(eh, "STexampleData")
ah_id <- myfiles$ah_id[myfiles$title == 'Visium_humanDLPFC']
spe <- myfiles[[ah_id]]
spe <- spe[, colData(spe)$in_tissue == 1]
spe <-scater::logNormCounts(spe)
genes <- c('MOBP', 'PCP4', 'SNAP25', 'HBB', 'IGKC', 'NPY')
target.features <- rownames(spe)[match(genes, rowData(spe)$gene_name)]
library(SVP)
lisa.res1 <- runLISA(spe,
                     assay.type='logcounts',
                     features=target.features[seq(2)],
                     weight.method='knn', 
                     k=50)
plot_lisa_feature(spe, lisa.res=lisa.res1, features=target.features[seq(2)],
                  pointsize=2, hlpointsize=2, gap_line_width=.1)
}
}
