% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_trend.R
\name{mean_trend}
\alias{mean_trend}
\title{Function for Generating Various Longitudinal Mean Trends}
\usage{
mean_trend(
  timepoints,
  form = c("linear", "quadratic", "cubic", "M", "W", "L_up", "L_down"),
  beta,
  IP = NULL,
  plot_trend = FALSE
)
}
\arguments{
\item{timepoints}{numeric vector specifying the points to fit the functional
trend.}

\item{form}{character value specifying the type of time trend. Options
include 'linear', 'quadratic', 'cubic', 'M', 'W', 'L_up', and 'L_down'.}

\item{beta}{vector specifying the appropriate parameters for the equation.
In the case of 'linear', beta should be a two-dimensional vector specifying
the intercept and slope. See details for the further explanation of the beta
value for each form.}

\item{IP}{vector specifying the inflection points where changes occur for
functional forms M, W, and L trends.}

\item{plot_trend}{logical value indicating whether a plot should be produced
for the time trend. By default this is set to TRUE.}
}
\value{
This function returns a list of the following

\code{form} - character value repeating the form selected

\code{trend} - data.frame with the variables \code{mu} representing the
estimated mean value at \code{timepoints} used for fitting the trend

\code{beta} - returning the numeric vector used to fit the functional form
}
\description{
In order to investigate different functional forms of longitudinal
differential abundance we allow the mean time trend to take a variety of
forms.
These functional forms include linear, quadratic, cubic, M, W, L_up, or
L_down. For each form the direction/concavity/fold change can be specified
using the beta parameter.
}
\details{
Linear Form Notes:
\deqn{f(x)=\beta_0+\beta_{1}x+\beta_{2}x^2}
\itemize{
\item{Sign of \eqn{\beta_1} determines whether the trend is increasing (+)
or decreasing (-)}
}

Quadratic Form Notes:
\deqn{f(x)=\beta_0+\beta_{1}x+\beta_{2}x^2}
\itemize{
\item{Critical point for quadratic function occurs at the point
\eqn{\frac{-\beta_1}{2\beta_2}}}
\item{\eqn{\beta_2} determines whether the quadratic is concave up (+) or
concave down (-)}
}

Cubic Form Notes:
\deqn{f(x)=\beta_0+\beta_{1}x+\beta_{2}x^2+\beta_{3}x^{3}}
\itemize{
\item{Point of Inflection for cubic function occurs
\eqn{\frac{-\beta_{2}}{(3\beta_{3})}}}
\item{Critical points for cubic function occur at
\eqn{\frac{-\beta_{2}\pm\sqrt{\beta_2^{2}-3\beta_{1}\beta_{3}}}{3\beta_3}}}
\item{Can generate piecewise linear trends, i.e. 'V' form, by placing either
one of the IP points outside of the timepoints specified}
}

M/W Form Notes:
\itemize{
\item{Must specify beta as (\eqn{\beta_0}, \eqn{\beta_1}) and IP
as (\eqn{IP_1}, \eqn{IP_2}, \eqn{IP_3})}
\item{This form should be specified with an initial intercept,
\eqn{\beta_0}, and slope, \eqn{\beta_1},
that will connect to the first point of change (IP) specified.}
\item{Subsequent slopes are constructed such that the mean value at the
second IP value and final timepoint are 0}
\item{The mean value at the third IP is set to be equal to the calculcated
mean value at the first IP based on the specified intercept and slope.}
\item{\eqn{\beta_0}=intercept, i.e. timepoint when y=0}
\item{\eqn{\beta_1}=slope between \eqn{\beta_0} and \eqn{IP_1}}
}

L_up Form Notes:

The structure of this form assumes that there is no trend from \eqn{t_{1}} to
\eqn{IP_{1}}.
Then at the point of change specified, \eqn{IP_{1}}, there occurs a linearly
increasing trend with slope equal to \eqn{\beta_{slope}} up to the last
specified timepoint \eqn{t_{q}}.
\itemize{
\item{Must specify beta as (\eqn{\beta_{slope}}), and must be positive}
\item{Specify a single point of change (IP) variable where positive trend
will start}
\item{IP must be between [\eqn{t_{1}}, \eqn{t_{q}}]}
}

L_down Form Notes:

Similarily, the L_down form assumes that there are two region within the
range of timepoints. The first region is a decreasing trend and the second
region has no trend.
The decreasing trend must start with a Y intercept greater than zero, and the
slope must be specified as negative. There is one point of change (IP),
but this is
calculated automatically based on the values of the Y intercept and slope
provided, IP=\eqn{-\beta_{yintercept}/\beta_{slope}}.
\itemize{
\item{Must specify beta as (\eqn{\beta_{yintercept}}, \eqn{\beta_{slope}})
where \eqn{\beta_{yintercept}}>0 and \eqn{\beta_{slope}}<0}
\item{IP variable should be specified as NULL, if value is provided it will
be ignored.}
}
}
\examples{
#Quadratic Form
mean_trend(timepoints=seq(0, 6, length.out=20),
               form='quadratic', beta=1/4 * c(-1, 3, -0.5), plot_trend=TRUE)
#M Form
mean_trend(timepoints=seq(0, 10,length.out=100), form='M',
               beta=c(0, 5), IP=10 * c(1/4, 2/4, 3/4), plot_trend=TRUE)
#in this case the IP points are selected so that peaks are evenly
#distributed but this does not have to be true in general

#L_up Form
mean_trend(timepoints=seq(0, 10, length.out=100), form='L_up',
           beta=1, IP=5, plot_trend=TRUE)

#L_down Form
mean_trend(timepoints=seq(0, 10,length.out=100), form='L_down',
           beta=c(4, -0.5), IP=NULL, plot_trend=TRUE)

}
