% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNC.R
\name{KNC}
\alias{KNC}
\title{k-nearest class means (KNC)}
\usage{
KNC(xorigin, ximputed, class, k = 3)
}
\arguments{
\item{xorigin}{numeric matrix. The original log-intensity data. Can contain missing values.}

\item{ximputed}{numeric matrix. The imputed log-intensity data.}

\item{class}{factor. A vector of length number of columns (samples) in the data specifying the class/label (i.e. experimental group) of each sample.}

\item{k}{number of nearest class means. default to k=3.}
}
\value{
numeric  The proportion of preserved k-nearest class means in imputed data.
}
\description{
The fraction of k-nearest class means in the original data that are preserved as k-nearest class means in imputed data. KNC
quantifies preservation of the mesoscopic structure after imputation.
Requires complete datasets - for developers/use in benchmark studies only.
}
\examples{
data(pxd007959)
y <- pxd007959$y
y <- y[complete.cases(y),]
# for demonstration we use same y for xorigin and ximputed
KNC(y, y, class = as.factor(pxd007959$samples$group))

}
