% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiseqr_helpers.R
\name{quantiplot}
\alias{quantiplot}
\title{Plot the information on the tumor immune contexture}
\usage{
quantiplot(obj)
}
\arguments{
\item{obj}{An object, either
\itemize{
\item a \code{SummarizedExperiment} where the quantifications are stored
\item a simple data.frame object, as obtained by \code{run_quantiseqr()}
}}
}
\value{
A ggplot object
}
\description{
Plot the information on the tumor immune contexture, as extracted with
\code{run_quantiseqr()}
}
\examples{
data(dataset_racle)
dim(dataset_racle$expr_mat)
res_quantiseq_run <- quantiseqr::run_quantiseq(
  expression_data = dataset_racle$expr_mat,
  signature_matrix = "TIL10",
  is_arraydata = FALSE,
  is_tumordata = TRUE,
  scale_mRNA = TRUE
)

# using a SummarizedExperiment object
library("SummarizedExperiment")
se_racle <- SummarizedExperiment(
  assays = List(
    abundance = dataset_racle$expr_mat
  ),
  colData = DataFrame(
    SampleName = colnames(dataset_racle$expr_mat)
  )
)

res_run_SE <- quantiseqr::run_quantiseq(
    expression_data = se_racle,
    signature_matrix = "TIL10",
    is_arraydata = FALSE,
    is_tumordata = TRUE,
    scale_mRNA = TRUE
)

quantiplot(res_quantiseq_run)
# equivalent to...
quantiplot(res_run_SE)

}
