% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiseqr_helpers.R
\name{se_to_matrix}
\alias{se_to_matrix}
\title{SummarizedExperiment to matrix}
\usage{
se_to_matrix(se, assay = "abundance")
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object, or any of its derivates, which
contains the information on the TPM expression values, which are stored in a
specified assay slot.}

\item{assay}{A character string, specifying the name of the \code{assays} component
of the \code{se} object. Defaults to "abundance", as this is the common convention
used e.g. by the \code{tximport} package to store the values imported from the
transcript level quantifications}
}
\value{
A matrix object, containing the TPM values, ready to be used in the
framework of \code{quantiseqr}
}
\description{
SummarizedExperiment to matrix
}
\examples{
library("SummarizedExperiment")
library("macrophage")
data("gse", package = "macrophage")
se <- gse

# If using ENSEMBL or Gencode gene annotation, you might want to convert the row names
## in this case, the gene symbols are provided as rowData information
rownames(se) <- rowData(se)$SYMBOL

tpm_matrix <- se_to_matrix(se, assay = "abundance")

## otherwise, you can map the identifiers via
library("org.Hs.eg.db")
library("AnnotationDbi")
se <- gse
# keep the parts before the '.', used in the Gencode annotation
rownames(se) <- substr(rownames(se), 1, 15)
gene_names <- mapIds(org.Hs.eg.db,
                     keys = rownames(se),
                     column = "SYMBOL",
                     keytype = "ENSEMBL")
rownames(se) <- gene_names

# If you require to convert the counts to TPMs by hand, you need a vector of
# gene lengths as well, and then run this simple function on the count matrix
counts_to_tpm <- function(counts, lengths) {
  ratio <- counts / lengths
  mytpm <- ratio / sum(ratio) * 1e6
  return(mytpm)
}
# then run via
# tpmdata <- counts_to_tpm(count_matrix, genelength_vector)

}
