% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressPC.R
\name{adjustPValues}
\alias{adjustPValues}
\title{Adjust P-Values in Regression Results}
\usage{
adjustPValues(
  regress_res,
  adjust_method = c("BH", "holm", "hochberg", "hommel", "bonferroni", "BY", "fdr",
    "none"),
  indep_var = c("cell_type", "dataset")
)
}
\arguments{
\item{regress_res}{A list containing regression results. The structure of the list
depends on the \code{indep_var} argument: if \code{indep_var} is "cell_type",
the list should contain regression summaries for each principal component (PC);
if \code{indep_var} is "dataset", it should contain summaries for each dataset.}

\item{adjust_method}{A character string specifying the method to adjust the p-values.
Options include "BH", "holm", "hochberg", "hommel", "bonferroni", "BY", "fdr", or "none".
Default is "BH" (Benjamini-Hochberg). Default is "BH".}

\item{indep_var}{A character string specifying the independent variable for the adjustment.
Options are "cell_type" (default) or "dataset".}
}
\value{
A list similar to \code{regress_res}, but with an added column for adjusted p-values
  in the coefficients tables.
}
\description{
Adjusts the p-values in the regression results using a specified adjustment method.
The adjustment is performed either for each principal component (PC) by cell type
or for each dataset, depending on the selected independent variable.
}
\details{
This function adjusts p-values from regression results stored in a list. The adjustment
can be applied either across cell types or datasets, depending on the user’s choice.
The method for adjusting p-values can be selected from various options such as Benjamini-Hochberg (BH),
Holm, and others, which are supported by the `p.adjust` function in R.
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
\keyword{internal}
