% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCramerPValue.R
\name{calculateCramerPValue}
\alias{calculateCramerPValue}
\title{Calculate Cramer Test P-Values for Two-Sample Comparison of Multivariate ECDFs}
\usage{
calculateCramerPValue(
  reference_data,
  query_data = NULL,
  ref_cell_type_col,
  query_cell_type_col = NULL,
  cell_types = NULL,
  pc_subset = 1:5,
  assay_name = "logcounts"
)
}
\arguments{
\item{reference_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the reference cells.}

\item{query_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the query cells.
If NULL, the PC scores are regressed against the cell types of the reference data.}

\item{ref_cell_type_col}{The column name in the \code{colData} of \code{reference_data} that identifies the cell types.}

\item{query_cell_type_col}{The column name in the \code{colData} of \code{query_data} that identifies the cell types.}

\item{cell_types}{A character vector specifying the cell types to include in the plot. If NULL, all cell types are included.}

\item{pc_subset}{A numeric vector specifying which principal components to include in the plot. Default is PC1 to PC5.}

\item{assay_name}{Name of the assay on which to perform computations. Default is "logcounts".}
}
\value{
A named vector of p-values from the Cramer test for each cell type.
}
\description{
This function performs the Cramer test for comparing multivariate empirical cumulative distribution functions (ECDFs)
between two samples.
}
\details{
The function performs the following steps:
\enumerate{
  \item Projects the data into the PCA space.
  \item Subsets the data to the specified cell types and principal components.
  \item Performs the Cramer test for each cell type using the \code{cramer.test} function in the \code{cramer} package.
}
}
\examples{
# Load data
data("reference_data")
data("query_data")

# Plot the PC data (with query data)
cramer_test <- calculateCramerPValue(reference_data = reference_data,
                                     query_data = query_data,
                                     ref_cell_type_col = "expert_annotation",
                                     query_cell_type_col = "SingleR_annotation",
                                     cell_types = c("CD4", "CD8", "B_and_plasma", "Myeloid"),
                                     pc_subset = 1:5)
cramer_test

}
\references{
Baringhaus, L., & Franz, C. (2004). "On a new multivariate two-sample test".
Journal of Multivariate Analysis, 88(1), 190-206.
}
