% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateHotellingPValue.R
\name{calculateHotellingPValue}
\alias{calculateHotellingPValue}
\title{Perform Hotelling's T-squared Test on PCA Scores for Single-cell RNA-seq Data}
\usage{
calculateHotellingPValue(
  query_data,
  reference_data,
  query_cell_type_col,
  ref_cell_type_col,
  cell_types = NULL,
  pc_subset = 1:5,
  n_permutation = 500,
  assay_name = "logcounts"
)
}
\arguments{
\item{query_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the query cells.}

\item{reference_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the reference cells.}

\item{query_cell_type_col}{character. The column name in the \code{colData} of \code{query_data}
that identifies the cell types.}

\item{ref_cell_type_col}{character. The column name in the \code{colData} of \code{reference_data}
that identifies the cell types.}

\item{cell_types}{A character vector specifying the cell types to include in the plot. If NULL, all cell types are included.}

\item{pc_subset}{A numeric vector specifying which principal components to include in the plot. Default is PC1 to PC5.}

\item{n_permutation}{Number of permutations to perform for p-value calculation. Default is 500.}

\item{assay_name}{Name of the assay on which to perform computations. Default is "logcounts".}
}
\value{
A named numeric vector of p-values from Hotelling's T-squared test for each cell type.
}
\description{
Computes Hotelling's T-squared test statistic and p-values for each specified cell type
based on PCA-projected data from query and reference datasets.
}
\details{
This function calculates Hotelling's T-squared statistic for comparing multivariate means
between reference and query datasets, projected onto a subset of principal components (PCs).
It performs a permutation test to obtain p-values for each cell type specified.
}
\examples{
# Load data
data("reference_data")
data("query_data")

# Get the p-values
p_values <- calculateHotellingPValue(query_data = query_data,
                                     reference_data = reference_data,
                                     query_cell_type_col = "SingleR_annotation",
                                     ref_cell_type_col = "expert_annotation",
                                     pc_subset = 1:10)
round(p_values, 5)

}
\references{
Hotelling, H. (1931). "The generalization of Student's ratio". *Annals of Mathematical Statistics*. 2 (3): 360–378. doi:10.1214/aoms/1177732979.
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
