% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateNearestNeighborProbabilities.R,
%   R/plot.calculateNearestNeighborProbabilitiesObject.R
\name{calculateNearestNeighborProbabilities}
\alias{calculateNearestNeighborProbabilities}
\alias{plot.calculateNearestNeighborProbabilitiesObject}
\title{Calculate Nearest Neighbor Diagnostics for Cell Type Classification}
\usage{
calculateNearestNeighborProbabilities(
  query_data,
  reference_data,
  query_cell_type_col,
  ref_cell_type_col,
  cell_types = NULL,
  pc_subset = 1:5,
  n_neighbor = 20,
  assay_name = "logcounts"
)

\method{plot}{calculateNearestNeighborProbabilitiesObject}(x, cell_types = NULL, ...)
}
\arguments{
\item{query_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the query cells.}

\item{reference_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the reference cells.}

\item{query_cell_type_col}{A character string specifying the column name in the query dataset containing cell type annotations.}

\item{ref_cell_type_col}{A character string specifying the column name in the reference dataset containing cell type annotations.}

\item{cell_types}{A character vector specifying the cell types to include in the plot. If NULL, all cell types in \code{x} will be plotted. Default is NULL.}

\item{pc_subset}{A vector specifying the subset of principal components to use in the analysis. Default is 1:5}

\item{n_neighbor}{An integer specifying the number of nearest neighbors to consider. Default is 20.}

\item{assay_name}{Name of the assay on which to perform computations. Default is "logcounts".}

\item{x}{An object of class \code{nearestNeighbotDiagnostics} containing the probabilities calculated by the \code{\link{calculateNearestNeighborProbabilities}} function.}

\item{...}{Additional arguments to be passed to \code{\link[ggplot2]{geom_density}}.}
}
\value{
A list where each element corresponds to a cell type and contains:
\item{n_neighbor}{The number of nearest neighbors considered.}
\item{n_query}{The number of cells in the query dataset for each cell type.}
\item{query_prob}{The average probability of each query cell belonging to the reference dataset.}
The list is assigned the class \code{"calculateNearestNeighborProbabilities"}.
Each element in the list is named after the respective cell type.

The S3 plot method returns a \code{ggplot} density plot.
}
\description{
This function computes the probabilities for each query cell of belonging to either the reference or query dataset for
each cell type using nearest neighbor analysis.

The S3 plot method generates a density plot showing the distribution of probabilities for each cell of belonging to
either the reference or query dataset for each cell type.
}
\details{
The function conducts PCA on both the query and reference datasets to reduce dimensionality. It then compares each query
cell to its nearest neighbors in the reference dataset to estimate the probability of membership in each cell type. Sample sizes
between datasets are balanced using data augmentation if necessary.

The S3 plot method creates a density plot to visualize the distribution of probabilities for each cell belonging to the
reference or query dataset for each cell type. It utilizes the ggplot2 package for plotting.
}
\examples{
# Load data
data("reference_data")
data("query_data")

# Project the query data onto PCA space of reference
nn_output <- calculateNearestNeighborProbabilities(query_data = query_data,
                                                   reference_data = reference_data,
                                                   query_cell_type_col = "SingleR_annotation",
                                                   ref_cell_type_col = "expert_annotation",
                                                   pc_subset = 1:10,
                                                   n_neighbor = 20)

# Plot output
plot(nn_output, cell_types = c("CD4", "CD8", "B_and_plasma", "Myeloid"))

}
\seealso{
\code{\link{plot.calculateNearestNeighborProbabilitiesObject}}

\code{\link{calculateNearestNeighborProbabilities}}
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
\keyword{internal}
