% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histQCvsAnnotation.R
\name{histQCvsAnnotation}
\alias{histQCvsAnnotation}
\title{Histograms: QC Stats and Annotation Scores Visualization}
\usage{
histQCvsAnnotation(
  se_object,
  cell_type_col,
  cell_types = NULL,
  qc_col,
  score_col
)
}
\arguments{
\item{se_object}{A \code{\linkS4class{SingleCellExperiment}} containing the single-cell 
expression data and metadata.}

\item{cell_type_col}{The column name in the \code{colData} of \code{se_object} 
that contains the cell type labels.}

\item{cell_types}{A vector of cell types to plot (e.g., c("T-cell", "B-cell")).
Defaults to \code{NULL}, which will include all the cells.}

\item{qc_col}{A column name in the \code{colData} of \code{se_object} that 
contains the QC stats of interest.}

\item{score_col}{The column name in the \code{colData} of \code{se_object} that 
contains the cell type scores.}
}
\value{
A object containing two histograms displayed side by side. 
The first histogram represents the distribution of QC stats, 
and the second histogram represents the distribution of annotation scores.
}
\description{
This function generates histograms for visualizing the distribution of quality control (QC) statistics and 
annotation scores associated with cell types in single-cell genomic data.
}
\details{
The particularly useful in the analysis of data from single-cell experiments, 
where understanding the distribution of these metrics is crucial for quality assessment and 
interpretation of cell type annotations.
}
\examples{
data("query_data")

# Generate histograms
histQCvsAnnotation(se_object = query_data, 
                   cell_type_col = "SingleR_annotation", 
                   cell_types = c("CD4", "CD8"),
                   qc_col = "percent_mito", 
                   score_col = "annotation_scores")

histQCvsAnnotation(se_object = query_data, 
                   cell_type_col = "SingleR_annotation", 
                   cell_types = NULL,
                   qc_col = "percent_mito", 
                   score_col = "annotation_scores")

}
