% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCellTypeMDS.R
\name{plotCellTypeMDS}
\alias{plotCellTypeMDS}
\title{Plot Reference and Query Cell Types using MDS}
\usage{
plotCellTypeMDS(
  query_data,
  reference_data,
  query_cell_type_col,
  ref_cell_type_col,
  cell_types = NULL,
  assay_name = "logcounts"
)
}
\arguments{
\item{query_data}{A \code{\linkS4class{SingleCellExperiment}} containing the single-cell 
expression data and metadata.}

\item{reference_data}{A \code{\linkS4class{SingleCellExperiment}} object containing the single-cell 
expression data and metadata.}

\item{query_cell_type_col}{The column name in the \code{colData} of \code{query_data} that identifies the cell types.}

\item{ref_cell_type_col}{The column name in the \code{colData} of \code{reference_data} that identifies the cell types.}

\item{cell_types}{A character vector specifying the cell types to include in the plot. If NULL, all cell types are included.}

\item{assay_name}{Name of the assay on which to perform computations. Default is "logcounts".}
}
\value{
A ggplot object representing the MDS scatter plot with cell type coloring.
}
\description{
This function facilitates the assessment of similarity between reference and query datasets 
through Multidimensional Scaling (MDS) scatter plots. It allows the visualization of cell types, 
color-coded with user-defined custom colors, based on a dissimilarity matrix computed from a 
user-selected gene set.
}
\details{
To evaluate dataset similarity, the function selects specific subsets of cells from 
both reference and query datasets. It then calculates Spearman correlations between gene expression profiles, 
deriving a dissimilarity matrix. This matrix undergoes Classical Multidimensional Scaling (MDS) for 
visualization, presenting cell types in a scatter plot, distinguished by colors defined by the user.
}
\examples{
# Load data
data("reference_data")
data("query_data")

# Generate the MDS scatter plot with cell type coloring
mds_plot <- plotCellTypeMDS(query_data = query_data, 
                            reference_data = reference_data, 
                            cell_types = c("CD4", "CD8", "B_and_plasma", "Myeloid")[1:4],
                            query_cell_type_col = "SingleR_annotation", 
                            ref_cell_type_col = "expert_annotation")
mds_plot

}
\references{
\itemize{
\item Kruskal, J. B. (1964). "Multidimensional scaling by optimizing goodness of fit to a nonmetric hypothesis". *Psychometrika*, 29(1), 1-27. doi:10.1007/BF02289565.
\item Borg, I., & Groenen, P. J. F. (2005). *Modern multidimensional scaling: Theory and applications* (2nd ed.). Springer Science & Business Media. doi:10.1007/978-0-387-25975-1.
}
}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
