% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCellTypePCA.R
\name{plotCellTypePCA}
\alias{plotCellTypePCA}
\title{Plot Principal Components for Different Cell Types}
\usage{
plotCellTypePCA(
  query_data,
  reference_data,
  query_cell_type_col,
  ref_cell_type_col,
  cell_types = NULL,
  pc_subset = 1:5,
  assay_name = "logcounts"
)
}
\arguments{
\item{query_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the query cells.}

\item{reference_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the reference cells.}

\item{query_cell_type_col}{The column name in the \code{colData} of \code{query_data} that identifies the cell types.}

\item{ref_cell_type_col}{The column name in the \code{colData} of \code{reference_data} that identifies the cell types.}

\item{cell_types}{A character vector specifying the cell types to include in the plot. If NULL, all cell types are included.}

\item{pc_subset}{A numeric vector specifying which principal components to include in the plot. Default is 1:5.}

\item{assay_name}{Name of the assay on which to perform computations. Default is "logcounts".}
}
\value{
A ggplot object representing the boxplots of specified principal components for the given cell types and datasets.
}
\description{
This function plots the principal components for different cell types in the query and reference datasets.
}
\details{
This function projects the query dataset onto the principal component space of the reference dataset and then plots the 
specified principal components for the specified cell types.
It uses the `projectPCA` function to perform the projection and \code{ggplot2} to create the plots.
}
\examples{
# Load data
data("reference_data")
data("query_data")

# Plot the PC data
pc_plot <- plotCellTypePCA(query_data = query_data, 
                           reference_data = reference_data,
                           cell_types = c("CD4", "CD8", "B_and_plasma", "Myeloid"),
                           query_cell_type_col = "expert_annotation", 
                           ref_cell_type_col = "expert_annotation", 
                           pc_subset = 1:5)
pc_plot

}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
