% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneSetScores.R
\name{plotGeneSetScores}
\alias{plotGeneSetScores}
\title{Visualization of gene sets or pathway scores on dimensional reduction plot}
\usage{
plotGeneSetScores(
  se_object,
  method = c("PCA", "TSNE", "UMAP"),
  score_col,
  pc_subset = 1:5
)
}
\arguments{
\item{se_object}{An object of class \code{\linkS4class{SingleCellExperiment}} containing numeric expression matrix and other metadata.
It can be either a reference or query dataset.}

\item{method}{A character string indicating the method for visualization ("PCA", "TSNE", or "UMAP").}

\item{score_col}{A character string representing the name of the score_col (score) in the colData(se_object) to plot.}

\item{pc_subset}{An optional vector specifying the principal components (PCs) to include in the plot if method = "PCA".
Default is 1:5.}
}
\value{
A ggplot2 object representing the gene set scores plotted on the specified reduced dimensions.
}
\description{
Plot gene sets or pathway scores on PCA, TSNE, or UMAP. Single cells are color-coded by scores of gene sets or pathways.
}
\details{
This function plots gene set scores on reduced dimensions such as PCA, t-SNE, or UMAP.
It extracts the reduced dimensions from the provided SingleCellExperiment object.
Gene set scores are visualized as a scatter plot with colors indicating the scores.
For PCA, the function automatically includes the percentage of variance explained
in the plot's legend.
}
\examples{
# Load data
data("query_data")

# Plot gene set scores on PCA
plotGeneSetScores(se_object = query_data,
                  method = "PCA",
                  score_col = "gene_set_scores",
                  pc_subset = 1:5)

# Note: Users can provide their own gene set scores in the colData of the 'se_object' object,
# using any dimension reduction of their choice.

}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
