% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDocumentation.R
\docType{data}
\name{query_data}
\alias{query_data}
\title{Query Single-Cell RNA-Seq Dataset}
\format{
An object of class \code{SingleCellExperiment} with 392 rows and 503 columns.
}
\source{
The HeOrganAtlas dataset, available through the scRNAseq package.
}
\usage{
query_data
}
\description{
This dataset contains the processed query dataset from the HeOrganAtlas dataset for Marrow tissue.
It has been preprocessed to include log-normalized counts, specific metadata columns, annotations 
based on SingleR cell type scoring, and PCA, t-SNE, and UMAP results.
}
\details{
This dataset underwent the following steps:
\itemize{
  \item Loads the HeOrganAtlas dataset specifically for Marrow tissue from the \code{scRNAseq} package.
  \item Divides the loaded dataset into a query dataset used for downstream analysis.
  \item Performs log normalization on the query dataset using the function \code{logNormCounts} from the \code{scuttle} package.
  \item Selects specific columns (\code{percent_mito}, \code{expert_annotation}) from the cell metadata for downstream analysis.
  \item Adds SingleR annotations (\code{SingleR_annotation}) and annotation scores (\code{annotation_scores}) to the query dataset using the function \code{SingleR} from the \code{SingleR} package.
  \item Computes AUC gene set scores using the function \code{AUCell_calcAUC} from the \code{AUCell} package and adds these scores to the query dataset.
  \item Selects highly variable genes (HVGs) using the function \code{getTopHVGs} from the \code{scran} package on the query dataset.
  \item Intersects the highly variable genes between the query and reference datasets to obtain common genes for analysis.
  \item Performs Principal Component Analysis (PCA) on the query dataset using the function \code{runPCA} from the \code{scater} package.
  \item Performs t-Distributed Stochastic Neighbor Embedding (t-SNE) on the query dataset using the function \code{runTSNE} from the \code{scater} package.
  \item Performs Uniform Manifold Approximation and Projection (UMAP) on the query dataset using the function \code{runUMAP} from the \code{scater} package.
}
}
\examples{
# Load and explore the query dataset
data("query_data")

}
\references{
He, et al. (2020). HeOrganAtlas: a comprehensive human organ atlas based on single-cell RNA sequencing.
}
\seealso{
Use \code{data("query_data")} to load and access the resulting query dataset and the
\code{data("reference_data")} for comparison with the reference dataset.
}
\keyword{internal}
