% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scDiagnostics-package.R
\docType{package}
\name{scDiagnostics-package}
\alias{scDiagnostics-package}
\alias{scDiagnostics}
\title{scDiagnostics: Single-Cell Diagnostics Package}
\description{
`scDiagnostics` is a comprehensive toolkit designed for the analysis and diagnostics of single-cell RNA sequencing (scRNA-seq) data. This package provides functionalities for comparing principal components, visualizing canonical correlation analysis (CCA) outputs, and plotting cell type-specific MDS and PCA projections.
}
\details{
The package includes the following key functionalities, organized by their specific purposes:
}
\section{Visualization of Cell Type Annotations}{

Functions for visualizing differences between query and reference datasets across multiple cell types.
\itemize{
  \item \code{\link{boxplotPCA}}: Boxplots of PCA scores for cell types.
  \item \code{\link{calculateDiscriminantSpace}}: Calculates discriminant space, with a plot method for visualization.
  \item \code{\link{plotCellTypeMDS}}: Creates MDS plots for cell types using query and reference datasets.
  \item \code{\link{plotCellTypePCA}}: Plots principal components for different cell types.
}
}

\section{Visualization of Marker Expressions}{

Functions for to visualize and compare the expression of markers between a reference and a query dataset.
\itemize{
  \item \code{\link{plotGeneExpressionDimred}}: Plots gene expression in a dimensionality reduction space.
  \item \code{\link{plotMarkerExpression}}: Plots marker expression levels.
}
}

\section{Visualization of QC and Annotation Scores}{

Functions for visualizing quality control (QC) metrics or other characteristics of the data.
\itemize{
  \item \code{\link{histQCvsAnnotation}}: Plots histograms of QC metrics versus annotations.
  \item \code{\link{plotGeneSetScores}}: Plots scores of gene sets.
  \item \code{\link{plotQCvsAnnotation}}: Plots QC metrics versus annotations.
}
}

\section{Evaluation of Dataset Alignment}{

Functions for visualizing differences between query and reference datasets for a specific cell type.
\itemize{
  \item \code{\link{compareCCA}}: Compares CCA results, with a plot method for visualization.
  \item \code{\link{comparePCA}}: Compares PCA results, with a plot method for visualization.
  \item \code{\link{comparePCASubspace}}: Compares PCA subspace, with a plot method for visualization.
  \item \code{\link{plotPairwiseDistancesDensity}}: Plots the density of pairwise distances.
  \item \code{\link{calculateWassersteinDistance}}: Wasserstein distance for different cell types.
}
}

\section{Evaluation of Marker Gene Alignment}{

Functions for calculating overlap measures of genes between two datasets.
\itemize{
  \item \code{\link{calculateHVGOverlap}}: Calculates overlap of highly variable genes (HVG) between datasets.
  \item \code{\link{calculateVarImpOverlap}}: Calculates overlap of variable importance measures between datasets.
}
}

\section{Calculation of Statistical Measures to Compare Two Datasets}{

Functions to compute statistical measures to compare two datasets.
\itemize{
  \item \code{\link{calculateCramerPValue}}: Calculates the p-value using Cramer's V.
  \item \code{\link{calculateHotellingPValue}}: Calculates the p-value using Hotelling's T-squared test.
  \item \code{\link{calculateNearestNeighborProbabilities}}: Calculates nearest neighbor probabilities, with a plot method for visualization.
  \item \code{\link{calculateAveragePairwiseCorrelation}}: Calculates average pairwise correlation, with a plot method for visualization.
  \item \code{\link{regressPC}}: Performs regression on principal components, with a plot method for visualization.
}
}

\section{Anomaly Detection (Global and Cell Type-Specific)}{

Functions for detecting anomalies at both the global and cell type-specific levels.
\itemize{
  \item \code{\link{detectAnomaly}}: Detects anomalies in the data, with a plot method for visualization.
  \item \code{\link{calculateCellSimilarityPCA}}: Calculates cell similarity in PCA space, with a plot method for visualization.
}
}

\section{Calculation of Distances Between Specific Cells and Cell Populations}{

Functions for calculating distances between specific cells and cell populations.
\itemize{
  \item \code{\link{calculateCellDistances}}: Calculates distances between cells, with a plot method for visualization.
  \item \code{\link{calculateCellDistancesSimilarity}}: Calculates similarity based on cell distances, with a plot method for visualization.
}
}

\section{Misc}{

Miscellaneous functions for various tasks.
\itemize{
  \item \code{\link{projectPCA}}: Projects new data into PCA space.
  \item \code{\link{calculateCategorizationEntropy}}: Calculates categorization entropy for clusters.
}

The package is built to facilitate in-depth analysis and visualization of single-cell data, enhancing the understanding of cell type similarities and differences across datasets.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ccb-hms/scDiagnostics}
  \item Report bugs at \url{https://github.com/ccb-hms/scDiagnostics/issues}
}

}
\author{
\strong{Maintainer}: Anthony Christidis \email{anthony-alexander_christidis@hms.harvard.edu} (\href{https://orcid.org/0000-0002-4565-6279}{ORCID})

Authors:
\itemize{
  \item Andrew Ghazi
  \item Smriti Chawla
  \item Ludwig Geistlinger
  \item Robert Gentleman
}

Other contributors:
\itemize{
  \item Nitesh Turaga [contributor]
}

}
\keyword{internal}
\keyword{package}
