# Load necessary libraries
library(testthat)
library(scDiagnostics)

# Load example datasets
data("qc_data")

test_that("plotQCvsAnnotation generates scatter plot correctly", {
    # Generate plot using the function
    p1 <- plotQCvsAnnotation(
        se_object = qc_data,
        cell_type_col = "SingleR_annotation",
        cell_types = NULL,
        qc_col = "total",
        score_col = "annotation_scores"
    )
    
    # Check if output is a ggplot object
    expect_s3_class(p1, "ggplot")
    
})

test_that("plotQCvsAnnotation handles invalid input gracefully", {
    # Test with non-existent column names in se_object
    expect_error(plotQCvsAnnotation(
        se_object = qc_data,
        cell_type_col = "invalid_column",
        cell_types = NULL,
        qc_col = "total",
        score_col = "annotation_scores"
    ))
    
    # Test with non-existent qc_col
    expect_error(plotQCvsAnnotation(
        se_object = qc_data,
        cell_type_col = "SingleR_annotation",
        cell_types = NULL,
        qc_col = "invalid_column",
        score_col = "annotation_scores"
    ))
    
    # Test with non-existent score_col
    expect_error(plotQCvsAnnotation(
        se_object = qc_data,
        cell_type_col = "SingleR_annotation",
        cell_types = NULL,
        qc_col = "total",
        score_col = "invalid_column"
    ))
})
