% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPICcompare.R
\name{addFeatureStats}
\alias{addFeatureStats}
\title{Add feature statistics}
\usage{
addFeatureStats(
  sce,
  value = "counts",
  log = FALSE,
  offset = 1,
  no.zeros = FALSE
)
}
\arguments{
\item{sce}{SingleCellExperiment to add feature statistics to.}

\item{value}{the count value to calculate statistics.}

\item{log}{logical. Whether to take log2 before calculating statistics.}

\item{offset}{offset to add to avoid taking log of zero.}

\item{no.zeros}{logical. Whether to remove all zeros from each feature
before calculating statistics.}
}
\value{
SingleCellExperiment with additional feature statistics
}
\description{
Add additional feature statistics to a SingleCellExperiment object
}
\details{
Currently adds the following statistics: mean and variance. Statistics
are added to the \code{\link{rowData}} slot and are named
\code{Stat[Log]Value[No0]} where \code{Log} and \code{No0} are added if
those arguments are true.
}
