% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPICcountclass.R
\docType{class}
\name{simPICcount}
\alias{simPICcount}
\alias{simPICcount-class}
\title{The simPICcount class}
\value{
a simPIC class object.
The parameters not shown in brackets can be estimated from real data
using \code{\link{simPICestimate}}. For details of the simPIC simulation
see \code{\link{simPICsimulate}}. The default parameters are based on PBMC10k
dataset and can be reproduced using test data and script provided in 
inst/script
}
\description{
S4 class that holds parameters for simPIC simulation.
}
\section{Parameters}{

simPIC simulation parameters:
\describe{
    \item{\code{nPeaks}}{The number of peaks to simulate.}
    \item{\code{nCells}}{The number of cells to simulate.}
    \item{\code{[seed]}}{Seed to use for generating random numbers.}
    \item{\code{[default]}}{The logical variable whether to use default
    parameters (TRUE) or learn from data (FALSE)}
    \item{\emph{Library size parameters}}{
        \describe{
            \item{\code{lib.size.meanlog}}{meanlog (location) parameter
            for the library size log-normal distribution.}
            \item{\code{lib.size.sdlog}}{sdlog (scale) parameter for the
            library size log-normal distribution.}
 }
}
     \item{\emph{Peak mean parameters}}{
        \describe{
            \item{\code{mean.scale}}{scale parameter for the mean
             weibull distribution.}
            \item{\code{mean.shape}}{shape parameter for the mean
            weibull distribution.}
 }
}
     \item{\emph{Cell sparsity parameters}}{
        \describe{
            \item{\code{sparsity}}{probability of openness to be
 multiplied to the input of poisson distribution to generate final
 simulated matrix.}
 }
}
}
}

