% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPICestimate.R
\name{simPICestimate}
\alias{simPICestimate}
\alias{simPICestimate.SingleCellExperiment}
\alias{simPICestimate.dgCMatrix}
\title{Estimate simPIC simulation parameters}
\usage{
simPICestimate(
  counts,
  object = newsimPICcount(),
  pm.distr = c("gamma", "weibull", "pareto", "lngamma"),
  verbose = TRUE
)

\method{simPICestimate}{SingleCellExperiment}(
  counts,
  object = newsimPICcount(),
  pm.distr = "weibull",
  verbose = TRUE
)

\method{simPICestimate}{dgCMatrix}(
  counts,
  object = newsimPICcount(),
  pm.distr = "weibull",
  verbose = TRUE
)
}
\arguments{
\item{counts}{either a sparse peak by cell count matrix, or a
SingleCellExperiment object containing count data to estimate
parameters.}

\item{object}{simPICcount object to store estimated parameters and
counts.}

\item{pm.distr}{statistical distribution for estimating peak mean
parameters. Available distributions: gamma, weibull, lngamma, pareto.
Default is weibull.}

\item{verbose}{logical variable. Prints the simulation progress if TRUE.}
}
\value{
simPICcount object containing all estimated parameters.
}
\description{
Estimate simulation parameters for library size, peak means, and sparsity
for simPIC simulation from a real peak by cell input matrix
}
\examples{
counts <- readRDS(system.file("extdata", "test.rds", package = "simPIC"))
est <- newsimPICcount()
est <- simPICestimate(counts, pm.distr = "weibull")
}
