% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPICsimulate.R
\name{simPICsimulate}
\alias{simPICsimulate}
\title{simPIC simulation}
\usage{
simPICsimulate(
  object = newsimPICcount(),
  verbose = TRUE,
  pm.distr = "weibull",
  ...
)
}
\arguments{
\item{object}{simPICcount object with simulation parameters.
See \code{\link{simPICcount}} for details.}

\item{verbose}{logical variable. Prints the simulation progress if TRUE.}

\item{pm.distr}{distribution parameter for peak means.
Available distributions: gamma, weibull, lngamma, pareto.
Default is weibull.}

\item{...}{Any additional parameter settings to override what is provided
in \code{simPICcount} object.}
}
\value{
SingleCellExperiment object containing the simulated counts.
}
\description{
Simulate peak by cell count matrix from a sparse single-cell ATAC-seq
peak by cell input using simPIC methods.
}
\details{
simPIC provides the option to manually adjust each of the
\code{simPICcount} object parameters by calling
\code{\link{setsimPICparameters}}.

 The simulation involves following steps:
 \enumerate{
 \item Set up simulation parameters
 \item Set up SingleCellExperiment object
 \item Simulate library sizes
 \item Simulate sparsity
 \item Simulate peak means
 \item Create final synthetic counts
 }

The final output is a
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object that
contains the simulated count matrix. The parameters are stored in the
\code{\link{colData}} (for cell specific information),
\code{\link{rowData}} (for peak specific information) or
\code{\link{assays}} (for peak by cell matrix) slots. This additional
information includes:
}
\examples{
# default simulation
sim <- simPICsimulate(pm.distr = "weibull")

}
