% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madSelect.R
\name{madSelect}
\alias{madSelect}
\title{Select hits basing on median +- k*MAD}
\usage{
madSelect(
  masterPlate,
  dat,
  k = 3,
  treatment,
  control,
  outFile = FALSE,
  normMethod = "PLATE"
)
}
\arguments{
\item{masterPlate}{the master plate to analysis}

\item{dat}{synthetic lethal RNAi screen data}

\item{k}{cutoff for selecting hits, default is three}

\item{treatment}{the treatment condition in EXPERIMENT_MODIFICATION}

\item{control}{the control condition in EXPERIMENT_MODIFICATION}

\item{outFile}{whether or not write the median normalized results}

\item{normMethod}{normalization methods to be used. If "PLATE", the raw readouts are normalized by plate median, otherwise use median provided control siRNA.}
}
\value{
A data.frame contains the hits selection results.
\itemize{
  \item MASTER_PLATE: location of siRNA
  \item treat_cont_ratio: ratio of treatment / control
  \item treat_median: median value of treatment plates
  \item control_median: median value of control plates
  \item Hits: Is this siRNA a hit?
}
}
\description{
Select hits basing on median +- k*MAD, by default k is three.
}
\examples{
data(example_dt)
res <- sapply((unique(example_dt$MASTER_PLATE)),
              madSelect,
              example_dt,
              control   = "control",
              treatment = "treatment",
              simplify  = FALSE)
}
\references{
Chung,N.etal. Median absolute deviation to improve hits election for genome-scale RNAi screens. J. Biomol. Screen. 13, 149-158 (2008).
}
