% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsClasses.R
\name{spsAccount}
\alias{spsAccount}
\title{SPS account management functions}
\description{
Initiate this container at global level.
Methods in this class can help admins to
manage accounts in a SPS project.

It uses a SQLite database, by default is created inside \code{config} directory on
SPS initialization.

You can use it to add/remove users, change user roles, change password,
match/verify account, password, role.

A default user account "user", with password "user", and a default admin account
"admin"  with password "admin" are create for you.

For app deployment, PLEASE create your own accounts and DELETE the default ones.
}
\examples{
dir.create("config", showWarnings = FALSE)
spsOption("verbose", TRUE)
spsOption("use_crayon", TRUE)
# create a new container
db <- spsAccount$new()
db$createDb()
# list all accounts
db$accList()
# add a new user
db$accAdd('user2', '!admin12345')
# list all accounts include password hash
db$accList(include_pass = TRUE)
# change password of an account
db$accPassChange("user2", "$aaaaaaa")
# check if pass changed
db$accList(include_pass = TRUE)
# change the role of from user to admin
db$accRoleChange("user2", "admin")
# check role change
db$accList()
# remove a user
db$accRemove("user2")
# check accounts again
db$accList()
# check if username and password matches
db$accMatch(acc_name = "user", acc_pass = "user")
# wrong pass
db$accMatch("user", "user123")
# also check if the user has the right role
db$accMatch("user", "user", role = "user", match_role = TRUE)
db$accMatch("user", "user", role = "admin", match_role = TRUE)
}
\section{Super classes}{
\code{\link[systemPipeShiny:spsDb]{systemPipeShiny::spsDb}} -> \code{\link[systemPipeShiny:spsEncryption]{systemPipeShiny::spsEncryption}} -> \code{spsaccount}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{spsAccount$new()}}
\item \href{#method-accList}{\code{spsAccount$accList()}}
\item \href{#method-accAdd}{\code{spsAccount$accAdd()}}
\item \href{#method-accRemove}{\code{spsAccount$accRemove()}}
\item \href{#method-accPassChange}{\code{spsAccount$accPassChange()}}
\item \href{#method-accRoleChange}{\code{spsAccount$accRoleChange()}}
\item \href{#method-accMatch}{\code{spsAccount$accMatch()}}
\item \href{#method-clone}{\code{spsAccount$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="createDb">}\href{../../systemPipeShiny/html/spsDb.html#method-createDb}{\code{systemPipeShiny::spsDb$createDb()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryDel">}\href{../../systemPipeShiny/html/spsDb.html#method-queryDel}{\code{systemPipeShiny::spsDb$queryDel()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryInsert">}\href{../../systemPipeShiny/html/spsDb.html#method-queryInsert}{\code{systemPipeShiny::spsDb$queryInsert()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryUpdate">}\href{../../systemPipeShiny/html/spsDb.html#method-queryUpdate}{\code{systemPipeShiny::spsDb$queryUpdate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryValue">}\href{../../systemPipeShiny/html/spsDb.html#method-queryValue}{\code{systemPipeShiny::spsDb$queryValue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryValueDp">}\href{../../systemPipeShiny/html/spsDb.html#method-queryValueDp}{\code{systemPipeShiny::spsDb$queryValueDp()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsEncryption" data-id="decrypt">}\href{../../systemPipeShiny/html/spsEncryption.html#method-decrypt}{\code{systemPipeShiny::spsEncryption$decrypt()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsEncryption" data-id="encrypt">}\href{../../systemPipeShiny/html/spsEncryption.html#method-encrypt}{\code{systemPipeShiny::spsEncryption$encrypt()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsEncryption" data-id="keyChange">}\href{../../systemPipeShiny/html/spsEncryption.html#method-keyChange}{\code{systemPipeShiny::spsEncryption$keyChange()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsEncryption" data-id="keyGet">}\href{../../systemPipeShiny/html/spsEncryption.html#method-keyGet}{\code{systemPipeShiny::spsEncryption$keyGet()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
initialize a new SPS account container
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsAccount$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-accList"></a>}}
\if{latex}{\out{\hypertarget{method-accList}{}}}
\subsection{Method \code{accList()}}{
list all accounts of the app. Returns a dataframe
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsAccount$accList(include_pass = FALSE, db_name = "config/sps.db")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_pass}}{bool, include password hash column?}

\item{\code{db_name}}{SPS database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-accAdd"></a>}}
\if{latex}{\out{\hypertarget{method-accAdd}{}}}
\subsection{Method \code{accAdd()}}{
add an account to use the app
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsAccount$accAdd(acc_name, acc_pass, role = "user", db_name = "config/sps.db")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acc_name}}{string, account name}

\item{\code{acc_pass}}{string, account password}

\item{\code{role}}{string, what kind role is this user, one of "user", "admin"}

\item{\code{db_name}}{SPS database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-accRemove"></a>}}
\if{latex}{\out{\hypertarget{method-accRemove}{}}}
\subsection{Method \code{accRemove()}}{
remove an account
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsAccount$accRemove(acc_name, db_name = "config/sps.db")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acc_name}}{string, account name}

\item{\code{db_name}}{SPS database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-accPassChange"></a>}}
\if{latex}{\out{\hypertarget{method-accPassChange}{}}}
\subsection{Method \code{accPassChange()}}{
change password of an account
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsAccount$accPassChange(acc_name, acc_pass, db_name = "config/sps.db")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acc_name}}{string, account name}

\item{\code{acc_pass}}{string, account new password}

\item{\code{db_name}}{SPS database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-accRoleChange"></a>}}
\if{latex}{\out{\hypertarget{method-accRoleChange}{}}}
\subsection{Method \code{accRoleChange()}}{
change the role of an account
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsAccount$accRoleChange(acc_name, role, db_name = "config/sps.db")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acc_name}}{string, account name}

\item{\code{role}}{string, one of "user" or "admin"}

\item{\code{db_name}}{SPS database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-accMatch"></a>}}
\if{latex}{\out{\hypertarget{method-accMatch}{}}}
\subsection{Method \code{accMatch()}}{
Try to see if the account name exists and has the right
password and role type, useful for login authentification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsAccount$accMatch(
  acc_name,
  acc_pass,
  role = "user",
  match_role = FALSE,
  db_name = "config/sps.db"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acc_name}}{string, account name}

\item{\code{acc_pass}}{string, account new password}

\item{\code{role}}{string, one of "user" or "admin"}

\item{\code{match_role}}{bool, also verify the account role type?}

\item{\code{db_name}}{SPS database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsAccount$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
