% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsClasses.R
\name{spsEncryption}
\alias{spsEncryption}
\title{SPS encryption functions}
\description{
Methods in this class can help admin to encrypt files been output from sps.
For now it is only used to encypt and decrypt snapshots.
This class requires the SPS database. This class inherits all functions from
the \link{spsDb} class, so there is no need to initiate the \code{spsDb} container.

This class is required to run a SPS app. This class needs to be initialized
global level. This has already been written in \emph{global.R} for you.
}
\examples{
dir.create("config", showWarnings = FALSE)
spsOption('verbose', TRUE)
my_ecpt <- spsEncryption$new()
my_ecpt$createDb()
# Read carefully before change the key
my_ecpt$keyChange()
# confirm
my_ecpt$keyChange(confirm = TRUE)
# imagine a file has one line "test"
writeLines(text = "test", con = "test.txt")
# encrypt the file
my_ecpt$encrypt("test.txt", "test.bin", overwrite = TRUE)
# decrypt the file
my_ecpt$decrypt("test.bin", "test_decpt.txt", overwrite = TRUE)
# check the decrypted file content
readLines('test_decpt.txt')
}
\section{Super class}{
\code{\link[systemPipeShiny:spsDb]{systemPipeShiny::spsDb}} -> \code{spsEncryption}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{spsEncryption$new()}}
\item \href{#method-keyChange}{\code{spsEncryption$keyChange()}}
\item \href{#method-keyGet}{\code{spsEncryption$keyGet()}}
\item \href{#method-encrypt}{\code{spsEncryption$encrypt()}}
\item \href{#method-decrypt}{\code{spsEncryption$decrypt()}}
\item \href{#method-clone}{\code{spsEncryption$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="createDb">}\href{../../systemPipeShiny/html/spsDb.html#method-createDb}{\code{systemPipeShiny::spsDb$createDb()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryDel">}\href{../../systemPipeShiny/html/spsDb.html#method-queryDel}{\code{systemPipeShiny::spsDb$queryDel()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryInsert">}\href{../../systemPipeShiny/html/spsDb.html#method-queryInsert}{\code{systemPipeShiny::spsDb$queryInsert()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryUpdate">}\href{../../systemPipeShiny/html/spsDb.html#method-queryUpdate}{\code{systemPipeShiny::spsDb$queryUpdate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryValue">}\href{../../systemPipeShiny/html/spsDb.html#method-queryValue}{\code{systemPipeShiny::spsDb$queryValue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="systemPipeShiny" data-topic="spsDb" data-id="queryValueDp">}\href{../../systemPipeShiny/html/spsDb.html#method-queryValueDp}{\code{systemPipeShiny::spsDb$queryValueDp()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
initialize a new class container
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsEncryption$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keyChange"></a>}}
\if{latex}{\out{\hypertarget{method-keyChange}{}}}
\subsection{Method \code{keyChange()}}{
Change encryption key of a SPS project
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsEncryption$keyChange(confirm = FALSE, db_name = "config/sps.db")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{confirm, }}{bool, confirm that you understand the consequence}

\item{\code{db_name}}{database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keyGet"></a>}}
\if{latex}{\out{\hypertarget{method-keyGet}{}}}
\subsection{Method \code{keyGet()}}{
Get encryption key from db of a SPS project
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsEncryption$keyGet(db_name = "config/sps.db")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db_name}}{database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-encrypt"></a>}}
\if{latex}{\out{\hypertarget{method-encrypt}{}}}
\subsection{Method \code{encrypt()}}{
Encrypt raw data or a file with key from a SPS project
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsEncryption$encrypt(
  data,
  out_path = NULL,
  overwrite = FALSE,
  db_name = "config/sps.db"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{raw vector or a file path}

\item{\code{out_path}}{if provided, encrypted data will be write to a file}

\item{\code{overwrite}}{if \code{out_path} file exists, overwrite?}

\item{\code{db_name}}{database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-decrypt"></a>}}
\if{latex}{\out{\hypertarget{method-decrypt}{}}}
\subsection{Method \code{decrypt()}}{
Decrypt raw data or a file with key from a SPS project
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsEncryption$decrypt(
  data,
  out_path = NULL,
  overwrite = FALSE,
  db_name = "config/sps.db"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{raw vector or a file path}

\item{\code{out_path}}{if provided, encrypted data will be write to a file}

\item{\code{overwrite}}{if \code{out_path} file exists, overwrite?}

\item{\code{db_name}}{database path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{spsEncryption$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
