% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsNewtab.R
\name{spsEzUI}
\alias{spsEzUI}
\alias{spsEzServer}
\title{Easy and simple UI and server for a SPS custom tab}
\usage{
spsEzUI(
  desc = "",
  tab_title = "Tab Title",
  plot_title = "My Plot",
  plot_control = shiny::tagList()
)

spsEzServer(
  plot_code,
  example_data_path = system.file(package = "systemPipeShiny", "app", "data",
    "iris.csv"),
  other_server_code = ""
)
}
\arguments{
\item{desc}{character string, length 1 in markdown format. Tab description
and instructions. You can make type it in multiple lines but in only one
string (one pair of quotes). e.g.\preformatted{"
# some desc
## second line,
- bullet 1
- bullet 2
"
}}

\item{tab_title}{string, tab title}

\item{plot_title}{string, plot title}

\item{plot_control}{some Shiny components (UI) to control the plot, like plot
title, x,y labels, color, font size, etc. Group all components in a shiny
\code{tagList}.}

\item{plot_code}{some R code to make the plot.}

\item{example_data_path}{example dataset path, this dataset will be loaded on
app start to display}

\item{other_server_code}{optional, other server R code to run for this tab}
}
\value{
\code{spsEzUI} returns a shiny module UI function, \code{spsEzServer} returns
the server function
}
\description{
SPS custom tab simple UI and server , \link{spsEzUI} must use together
with the \link{spsEzServer} function. The easiest way to use is to
use \link{spsNewTab} function to create both.
}
\examples{
# use `spsInit()` to create an SPS project and use `spsNewTab("Your_tabID", template = "easy")`
# to create a new tab file. The specified use of these two functions is in that file.
}
\seealso{
\link{spsNewTab}
}
