% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsCore.R
\name{spsInit}
\alias{spsInit}
\title{Create a SystemPipeShiny project}
\usage{
spsInit(
  app_path = getwd(),
  project_name = glue::glue("SPS_{format(Sys.time(), '\%Y\%m\%d')}"),
  database_name = "sps.db",
  overwrite = FALSE,
  change_wd = TRUE,
  verbose = FALSE,
  open_files = TRUE,
  colorful = TRUE
)
}
\arguments{
\item{app_path}{path, a directory where do you want to create this project,
must exist.}

\item{project_name}{Your project name, default is \code{SPS_} + \code{time}}

\item{database_name}{deprecated in current version.
project database name, recommend to use the default
name: "sps.db". It is used to store app meta information.}

\item{overwrite}{bool, overwrite the \code{app_path} if there is a folder that
has the same name as \code{project_name}?}

\item{change_wd}{bool, when creation is done, change working directory into
the project?}

\item{verbose}{bool, do you want additional message?}

\item{open_files}{bool, If \code{change_wd == TRUE} and you are also in Rstudio,
it will open up \emph{global.R} for you}

\item{colorful}{bool, should message from this function be colorful?}
}
\value{
creates the project folder
}
\description{
To run a SPS app, you need to first create a SPS project, a
directory contains the required files.
}
\details{
Make sure you have write permission to \code{app_path}.

The database in not used in current version.
}
\examples{
if(interactive()){
    spsInit(change_wd = FALSE)
}
}
