% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terraTCGAworkspaces.R
\name{terraTCGAworkspace}
\alias{terraTCGAworkspace}
\alias{selectTCGAworkspace}
\title{Obtain or set the Terra Workspace Project Dataset}
\usage{
terraTCGAworkspace(projectName = getOption("terraTCGAdata.workspace", NULL))

selectTCGAworkspace(
  projectName = getOption("terraTCGAdata.workspace", NULL),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{projectName}{character(1) A project code usually in the form of
\verb{TCGA_CODE_OpenAccess_V1-0_DATA}. See \code{selectTCGAworkspace} to
interactively select from a table of project codes.}

\item{verbose}{logical(1) Whether to provide more informative messages
when an the "terraTCGAdata.workspace" option is set.}

\item{...}{further arguments passed down to lower level functions, not
intended for the end user.}
}
\value{
A Terra TCGA Workspace name
}
\description{
Terra allows access to about 71 open access TCGA datasets. A dataset
workspace can be set using the \code{terraTCGAworkspace} function with a
\code{projectName} input. Use the \code{selectTCGAworkspace} function to select
a TCGA data workspace from an interactive table.
}
\details{
Note that GDC workspaces are not supported and are excluded
from the search results. GDC workspaces use a Terra workflow to download
TCGA data rather than providing Google Bucket storage locations for easy
data retrieval. To reset the \code{terraTCGAworkspace}, use
\code{terraTCGAworkspace(NULL)} and you will be prompted to select from a list
of TCGA workspaces. You may also check the current active workspace by
running \code{terraTCGAworkspace()} without any inputs.
}
\section{Functions}{
\itemize{
\item \code{selectTCGAworkspace()}: Function to interactively select from the
available TCGA data workspaces in Terra. The `projectName` argument and
'terraTCGAdata.workspace' option must be `NULL` to enable the interactive
gadget.

}}
\examples{
if (
    AnVILGCP::gcloud_exists() &&
    identical(AnVILBase::avplatform_namespace(), "AnVILGCP") &&
    nzchar(AnVILGCP::avworkspace_name())
) {
  selectTCGAworkspace()
  terraTCGAworkspace()
}

}
