###
###

.pkgname <- "BSgenome.Ecoli.NCBI.20080805"

.seqnames <- c(paste("NC_", c("008253", "008563", "010468", "004431", "009801", "009800", "002655", "002695", "010498", "007946", "010473", "000913"), sep=""), "AC_000091")

.circ_seqs <- c(paste("NC_", c("008253", "008563", "010468", "004431", "009801", "009800", "002655", "002695", "010498", "007946", "010473", "000913"), sep=""), "AC_000091")

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Escherichia coli",
        species="E. coli",
        provider="NCBI",
        provider_version="2008/08/05",
        release_date="NA",
        release_name="NA",
        source_url="ftp://ftp.ncbi.nih.gov/genomes/Bacteria/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Ecoli"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

