## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL
)

## ----eval = FALSE-------------------------------------------------------------
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#          install.packages("BiocManager")
#  BiocManager::install("MouseAgingData")

## ----message = FALSE----------------------------------------------------------
library(scater)
library(MouseAgingData)

## -----------------------------------------------------------------------------
sce <- parabiosis10x()

## -----------------------------------------------------------------------------
sce

## ----Data check---------------------------------------------------------------
head(colData(sce)) 

## ----fig.wide=TRUE------------------------------------------------------------
cell.color <- metadata(sce)$cell_color

gg <- plotUMAP(sce, color_by = "cell_type", text_by = "cell_type") 
gg + theme(legend.title=element_blank()) + 
    scale_color_manual(values=c(cell.color))

## ----plot provided tSNE, fig.wide=TRUE----------------------------------------
gg <- plotTSNE(sce, color_by = "cell_type", text_by = "cell_type") 
gg + theme(legend.title=element_blank()) + 
    scale_color_manual(values=c(cell.color))

## ----sesh info----------------------------------------------------------------
sessionInfo()

