## ----style, echo = FALSE, results = 'asis', message=FALSE---------------------
BiocStyle::markdown()

## ----setup, message = FALSE, echo = FALSE-------------------------------------
library("PSMatch")

## ----message = FALSE----------------------------------------------------------
(spf <- msdata::proteomics(pattern = "2014", full.names = TRUE))
library(Spectra)
sp <- Spectra(spf)

## -----------------------------------------------------------------------------
(idf <- msdata::ident(pattern = "2014", full.names = TRUE))
id <- PSM(idf) |> filterPSMs()
id

## -----------------------------------------------------------------------------
sp <- joinSpectraData(sp, id, by.x = "spectrumId", by.y = "spectrumID")
sp

## -----------------------------------------------------------------------------
sp5449 <- filterPrecursorScan(sp, 5449)

## -----------------------------------------------------------------------------
plotSpectra(sp5449[1], xlim = c(550, 1200))
abline(v = precursorMz(sp5449)[2], col = "red", lty = "dotted")

## -----------------------------------------------------------------------------
sp5449$sequence

## -----------------------------------------------------------------------------
calculateFragments(sp5449$sequence[2])

## -----------------------------------------------------------------------------
plotSpectra(sp5449[2])

## -----------------------------------------------------------------------------
plotSpectra(sp5449[2], labels = labelFragments, labelPos = 3)

## ----si-----------------------------------------------------------------------
sessionInfo()

