## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(cache = TRUE)

## ----include=TRUE,results="hide",message=FALSE,warning=FALSE------------------
library(cBioPortalData)
library(AnVIL)
library(jsonlite)

## -----------------------------------------------------------------------------
api_errs <- system.file(
    "extdata", "api", "err_api_info.json",
    package = "cBioPortalData", mustWork = TRUE
)
err_api_info <- fromJSON(api_errs)

## -----------------------------------------------------------------------------
class(err_api_info)
length(err_api_info)
lengths(err_api_info)

## -----------------------------------------------------------------------------
names(err_api_info)

## -----------------------------------------------------------------------------
err_api_info[['Inconsistent build numbers found']]

## -----------------------------------------------------------------------------
err_api_info

## -----------------------------------------------------------------------------
pack_errs <- system.file(
    "extdata", "pack", "err_pack_info.json",
    package = "cBioPortalData", mustWork = TRUE
)
err_pack_info <- fromJSON(pack_errs)

## -----------------------------------------------------------------------------
length(err_pack_info)
lengths(err_pack_info)

## -----------------------------------------------------------------------------
names(err_pack_info)

## -----------------------------------------------------------------------------
err_pack_info

## -----------------------------------------------------------------------------
sessionInfo()

