## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(cache = TRUE)

## ----include=TRUE,results="hide",message=FALSE,warning=FALSE------------------
library(cBioPortalData)

## ----comment=FALSE, warning=FALSE, message=FALSE------------------------------
cbio <- cBioPortal(
    hostname = "www.cbioportal.org",
    protocol = "https",
    api. = "/api/v2/api-docs"
)
getStudies(cbio)

## -----------------------------------------------------------------------------
head(getStudies(cbio)[["studyId"]])

## ----eval=FALSE---------------------------------------------------------------
# library(cgdsr)
# cgds <- CGDS("http://www.cbioportal.org/")
# getCancerStudies.CGDS(cgds)

## -----------------------------------------------------------------------------
samps <- sampleLists(cbio, "gbm_tcga_pub")
samps[, c("category", "name", "sampleListId")]

## -----------------------------------------------------------------------------
samplesInSampleLists(
    api = cbio,
    sampleListIds = c(
        "gbm_tcga_pub_expr_classical", "gbm_tcga_pub_expr_mesenchymal"
    )
)

## -----------------------------------------------------------------------------
getSampleInfo(api = cbio,  studyId = "gbm_tcga_pub", projection = "SUMMARY")

## ----eval=FALSE---------------------------------------------------------------
# clist1 <-
#     getCaseLists.CGDS(cgds, cancerStudy = "gbm_tcga_pub")[1, "case_list_id"]
# 
# getClinicalData.CGDS(cgds, clist1)

## -----------------------------------------------------------------------------
clinicalData(cbio, "gbm_tcga_pub")

## -----------------------------------------------------------------------------
clist1 <- "gbm_tcga_pub_all"
samplist <- samplesInSampleLists(cbio, clist1)
onesample <- samplist[["gbm_tcga_pub_all"]][1]
onesample

## -----------------------------------------------------------------------------
cbio$getAllClinicalDataOfSampleInStudyUsingGET(
    sampleId = onesample, studyId = "gbm_tcga_pub"
)

## ----eval = FALSE-------------------------------------------------------------
# getClinicalData.CGDS(x = cgds,
#     caseList = "gbm_tcga_pub_expr_classical"
# )

## -----------------------------------------------------------------------------
searchOps(cbio, "clinical")

## -----------------------------------------------------------------------------
molecularProfiles(api = cbio, studyId = "gbm_tcga_pub")

## ----eval=FALSE---------------------------------------------------------------
# getGeneticProfiles.CGDS(cgds, cancerStudy = "gbm_tcga_pub")

## -----------------------------------------------------------------------------
genetab <- queryGeneTable(cbio,
    by = "hugoGeneSymbol",
    genes = c("NF1", "TP53", "ABL1")
)
genetab
entrez <- genetab[["entrezGeneId"]]

## -----------------------------------------------------------------------------
allsamps <- samplesInSampleLists(cbio, "gbm_tcga_pub_all")

## ----eval=FALSE---------------------------------------------------------------
# getProfileData.CGDS(x = cgds,
#     genes = c("NF1", "TP53", "ABL1"),
#     geneticProfiles = "gbm_tcga_pub_mrna",
#     caseList = "gbm_tcga_pub_all"
# )

## -----------------------------------------------------------------------------
molecularData(cbio, "gbm_tcga_pub_mrna",
    entrezGeneIds = entrez, sampleIds = unlist(allsamps))

## -----------------------------------------------------------------------------
getDataByGenes(
    api =  cbio,
    studyId = "gbm_tcga_pub",
    genes = c("NF1", "TP53", "ABL1"),
    by = "hugoGeneSymbol",
    molecularProfileIds = "gbm_tcga_pub_mrna"
)

## -----------------------------------------------------------------------------
gbm_pub <- cBioPortalData(
    api = cbio,
    studyId = "gbm_tcga_pub",
    genes = c("NF1", "TP53", "ABL1"), by = "hugoGeneSymbol",
    molecularProfileIds = "gbm_tcga_pub_mrna"
)

assay(gbm_pub[["gbm_tcga_pub_mrna"]])[, 1:4]

## -----------------------------------------------------------------------------
mutationData(
    api = cbio,
    molecularProfileIds = "gbm_tcga_pub_mutations",
    entrezGeneIds = entrez,
    sampleIds = unlist(allsamps)
)

## -----------------------------------------------------------------------------
getDataByGenes(
    api = cbio,
    studyId = "gbm_tcga_pub",
    genes = c("NF1", "TP53", "ABL1"),
    by = "hugoGeneSymbol",
    molecularProfileIds = "gbm_tcga_pub_mutations"
)

## ----eval=FALSE---------------------------------------------------------------
# getMutationData.CGDS(
#     x = cgds,
#     caseList = "getMutationData",
#     geneticProfile = "gbm_tcga_pub_mutations",
#     genes = c("NF1", "TP53", "ABL1")
# )

## -----------------------------------------------------------------------------
getDataByGenes(
    api = cbio,
    studyId = "gbm_tcga_pub",
    genes = c("NF1", "TP53", "ABL1"),
    by = "hugoGeneSymbol",
    molecularProfileIds = "gbm_tcga_pub_cna_rae"
)

## -----------------------------------------------------------------------------
cBioPortalData(
    api = cbio,
    studyId = "gbm_tcga_pub",
    genes = c("NF1", "TP53", "ABL1"),
    by = "hugoGeneSymbol",
    molecularProfileIds = "gbm_tcga_pub_cna_rae"
)

## ----eval=FALSE---------------------------------------------------------------
# getProfileData.CGDS(
#     x = cgds,
#     genes = c("NF1", "TP53", "ABL1"),
#     geneticProfiles = "gbm_tcga_pub_cna_rae",
#     caseList = "gbm_tcga_pub_cna"
# )

## -----------------------------------------------------------------------------
getDataByGenes(
    api = cbio,
    studyId = "gbm_tcga_pub",
    genes = c("NF1", "TP53", "ABL1"),
    by = "hugoGeneSymbol",
    molecularProfileIds = "gbm_tcga_pub_methylation_hm27"
)

## -----------------------------------------------------------------------------
cBioPortalData(
    api = cbio,
    studyId = "gbm_tcga_pub",
    genes = c("NF1", "TP53", "ABL1"),
    by = "hugoGeneSymbol",
    molecularProfileIds = "gbm_tcga_pub_methylation_hm27"
)

## ----eval=FALSE---------------------------------------------------------------
# getProfileData.CGDS(
#     x = cgds,
#     genes = c("NF1", "TP53", "ABL1"),
#     geneticProfiles = "gbm_tcga_pub_methylation_hm27",
#     caseList = "gbm_tcga_pub_methylation_hm27"
# )

## -----------------------------------------------------------------------------
sessionInfo()

