% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_data_analysis.R
\name{bp_VIP_analysis}
\alias{bp_VIP_analysis}
\title{Bootstrap and permutation over PLS-VIP}
\usage{
bp_VIP_analysis(dataset, train_index, y_column, ncomp, nbootstrap = 300)
}
\arguments{
\item{dataset}{An \link{nmr_dataset_family} object}

\item{train_index}{set of index used to generate the bootstrap datasets}

\item{y_column}{A string with the name of the y column (present in the
metadata of the dataset)}

\item{ncomp}{number of components used in the plsda models}

\item{nbootstrap}{number of bootstrap dataset}
}
\value{
A list with the following elements:
\itemize{
\item \code{important_vips}: A list with the important vips selected
\item \code{relevant_vips}: List of vips with some relevance
\item \code{pls_vip}: Pls-VIPs of every bootstrap
\item \code{pls_vip_perm}: Pls-VIPs of every bootstrap with permuted variables
\item \code{pls_vip_means}: Pls-VIPs normaliced differences means
\item \code{pls_vip_score_diff}: Differences of \code{pls_vip} and \code{pls_vip_perm}
\item \code{pls_models}: pls models of the diferent bootstraps
\item \code{pls_perm_models}: pls permuted models of the diferent bootstraps
\item \code{classif_rate}: classification rate of the bootstrap models
\item \code{general_model}: pls model trained with all train data
\item \code{general_CR}: classification rate of the \code{general_model}
\item \code{vips_model}: pls model trained with vips selection over all train data
\item \code{vips_CR}: classification rate of the \code{vips_model}
\item \code{error}: error spected in a t distribution
\item \code{lower_bound}: lower bound of the confidence interval
\item \code{upper_bound}: upper bound of the confidence interval
}
}
\description{
Bootstrap and permutation over PLS-VIP on AlpsNMR can be performed on both
\link{nmr_dataset_1D} full spectra as well as \link{nmr_dataset_peak_table} peak tables.
}
\details{
Use of the bootstrap and permutation methods for a more robust
variable importance in the projection metric for partial least
squares regression
}
\examples{
# Data analysis for a table of integrated peaks

## Generate an artificial nmr_dataset_peak_table:
### Generate artificial metadata:
num_samples <- 32 # use an even number in this example
num_peaks <- 20
metadata <- data.frame(
    NMRExperiment = as.character(1:num_samples),
    Condition = rep(c("A", "B"), times = num_samples / 2)
)

### The matrix with peaks
peak_means <- runif(n = num_peaks, min = 300, max = 600)
peak_sd <- runif(n = num_peaks, min = 30, max = 60)
peak_matrix <- mapply(function(mu, sd) rnorm(num_samples, mu, sd),
    mu = peak_means, sd = peak_sd
)
colnames(peak_matrix) <- paste0("Peak", 1:num_peaks)

## Artificial differences depending on the condition:
peak_matrix[metadata$Condition == "A", "Peak2"] <-
    peak_matrix[metadata$Condition == "A", "Peak2"] + 70

peak_matrix[metadata$Condition == "A", "Peak6"] <-
    peak_matrix[metadata$Condition == "A", "Peak6"] - 60

### The nmr_dataset_peak_table
peak_table <- new_nmr_dataset_peak_table(
    peak_table = peak_matrix,
    metadata = list(external = metadata)
)

## We will use a double cross validation, splitting the samples with random
## subsampling both in the external and internal validation.
## The classification model will be a PLSDA, exploring at maximum 3 latent
## variables.
## The best model will be selected based on the area under the ROC curve
methodology <- plsda_auroc_vip_method(ncomp = 3)
model <- nmr_data_analysis(
    peak_table,
    y_column = "Condition",
    identity_column = NULL,
    external_val = list(iterations = 1, test_size = 0.25),
    internal_val = list(iterations = 3, test_size = 0.25),
    data_analysis_method = methodology
)
## Area under ROC for each outer cross-validation iteration:
model$outer_cv_results_digested$auroc

## The number of components for the bootstrap models is selected
ncomps <- model$outer_cv_results$`1`$model$ncomp
train_index <- model$train_test_partitions$outer$`1`$outer_train

# Bootstrap and permutation for VIP selection
bp_VIPS <- bp_VIP_analysis(peak_table, # Data to be analyzed
    train_index,
    y_column = "Condition",
    ncomp = ncomps,
    nbootstrap = 10
)

}
