% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_detect_peaks_align.R
\name{nmr_detect_peaks_plot}
\alias{nmr_detect_peaks_plot}
\title{Plot peak detection results}
\usage{
nmr_detect_peaks_plot(
  nmr_dataset,
  peak_data,
  NMRExperiment = NULL,
  peak_id = NULL,
  accepted_only = NULL,
  ...
)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D}.}

\item{peak_data}{The peak table returned by \link{nmr_detect_peaks}}

\item{NMRExperiment}{a single NMR experiment to plot}

\item{peak_id}{A character vector. If given, plot only that peak id.}

\item{accepted_only}{If \code{peak_data} contains a logical column named \code{accepted}, only those with \code{accepted=TRUE} will be counted. By default, \code{accepted_only = TRUE}, unless a \code{peak_id} is given}

\item{...}{Arguments passed to \link{plot.nmr_dataset_1D} (\code{chemshift_range}, \code{...})}
}
\value{
Plot peak detection results
}
\description{
Plot peak detection results
}
\seealso{
Peak_detection nmr_detect_peaks

Other peak detection functions: 
\code{\link{Pipelines}},
\code{\link{nmr_baseline_threshold}()},
\code{\link{nmr_detect_peaks}()},
\code{\link{nmr_detect_peaks_plot_overview}()},
\code{\link{nmr_detect_peaks_tune_snr}()},
\code{\link{nmr_identify_regions_blood}()},
\code{\link{nmr_identify_regions_cell}()},
\code{\link{nmr_identify_regions_urine}()},
\code{\link{nmr_integrate_regions}()}

Other peak detection functions: 
\code{\link{Pipelines}},
\code{\link{nmr_baseline_threshold}()},
\code{\link{nmr_detect_peaks}()},
\code{\link{nmr_detect_peaks_plot_overview}()},
\code{\link{nmr_detect_peaks_tune_snr}()},
\code{\link{nmr_identify_regions_blood}()},
\code{\link{nmr_identify_regions_cell}()},
\code{\link{nmr_identify_regions_urine}()},
\code{\link{nmr_integrate_regions}()}
}
\concept{peak detection functions}
