% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_data_analysis.R
\name{nmr_data_analysis_method}
\alias{nmr_data_analysis_method}
\alias{new_nmr_data_analysis_method}
\title{Create method for NMR data analysis}
\usage{
new_nmr_data_analysis_method(
  train_evaluate_model,
  train_evaluate_model_params_inner,
  choose_best_inner,
  train_evaluate_model_params_outer,
  train_evaluate_model_digest_outer
)
}
\arguments{
\item{train_evaluate_model}{A function. The \code{train_evaluate_model} must have the following signature:

\if{html}{\out{<div class="sourceCode">}}\preformatted{    function(x_train, y_train, identity_train, x_test, y_test, identity_test, ...)
}\if{html}{\out{</div>}}

The \code{x_train} and \code{y_train} (and their test counterparts) are self-explanatory.

The \code{identity_} arguments are expected to be factors. They can be used for
instance with a callback that uses \link[mixOmics:plsda]{mixOmics::plsda} in a \code{multilevel} approach
for longitudinal studies. In those studies the \code{identity} would be an
identifier of the subject.

The \code{...} arguments are free to be defined for each \code{train_evaluate_model}.}

\item{train_evaluate_model_params_inner, train_evaluate_model_params_outer}{A list with additional
arguments to pass to \code{train_evaluate_model} either in the inner cv loop or in the outer cv loop.}

\item{choose_best_inner}{A function with a single argument:

\if{html}{\out{<div class="sourceCode">}}\preformatted{function(inner_cv_results)
}\if{html}{\out{</div>}}

The argument is a list of \code{train_evaluate_model} outputs.
The return value of must be a list with at least an element named \code{train_evaluate_model_args}.
\code{train_evaluate_model_args} must be a named list.
\itemize{
\item Each element must be named as one of the \code{train_evaluate_model} arguments.
\item Each element must be a vector as long as the number of outer cross-validations.
\item The values of each vector must be the values that the \code{train_evaluate_model}
argument must take on each outer cross-validation iteration
Additional list elements can be returned and will be given back to the user
}}

\item{train_evaluate_model_digest_outer}{A function with a single argument:

function(outer_cv_results)

The argument is a list of \code{train_evaluate_model} outputs in outer cross-validation.
The return value is returned by \code{nmr_data_analysis}}
}
\value{
An object encapsulating the method dependent functions that can be used with \link{nmr_data_analysis}
}
\description{
Create method for NMR data analysis
}
