% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{alluvialPlot}
\alias{alluvialPlot}
\title{Alluvial plot}
\usage{
alluvialPlot(bsrinf, keywords, type = c("L", "R", "pw.id"), qval.thres = 0.01)
}
\arguments{
\item{bsrinf}{A BSRInference object.}

\item{keywords}{vector of keywoprds to filter pathways.}

\item{type}{filter on Ligand, Receptor or pathway id.}

\item{qval.thres}{threshold over Q-value.}
}
\value{
NULL

This is a convenience function that relies on the \code{ggalluvial}
package to propose a simple way
of representing ligands, receptors,
}
\description{
Representation of the links
between ligands, receptors, and pathways.
}
\examples{
data(bsrinf, package = "BulkSignalR")
alluvialPlot(bsrinf,
    keywords = c("LAMC1"),
    type = "L",
    qval.thres = 0.01)
}
