% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInferenceComp-class.R
\name{updateInference}
\alias{updateInference}
\alias{updateInference,BSRInferenceComp-method}
\title{Inference updating}
\usage{
\S4method{updateInference}{BSRInferenceComp}(
  obj,
  bsrcc,
  ncounts,
  src.bsrcc = NULL,
  rank.p = 0.55,
  max.pval = 0.01,
  min.logFC = 1,
  min.LR.score = 0,
  neg.receptors = FALSE,
  pos.targets = FALSE,
  neg.targets = FALSE,
  min.t.logFC = 0.5,
  min.positive = 2,
  fdr.proc = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH")
)
}
\arguments{
\item{obj}{BSRInferenceComp object.}

\item{bsrcc}{BSRClusterComp object relative to target cells.}

\item{ncounts}{Matrix counts normalized.}

\item{src.bsrcc}{BSRClusterComp object relative to source cells.}

\item{rank.p}{A number between 0 and 1 defining the rank of the last
considered target genes.}

\item{max.pval}{The maximum P-value imposed to both the ligand
and the receptor.}

\item{min.logFC}{The minimum log2 fold-change allowed for
both the receptor and the ligand.}

\item{min.LR.score}{The minimum LR-score allowed for the interaction.}

\item{neg.receptors}{A logical indicating whether receptors are only
allowed to be upregulated (FALSE), or up- and downregulated (TRUE).}

\item{pos.targets}{A logical imposing that all the network targets must
display positive logFC, i.e. logFC >= min.t.logFC.}

\item{neg.targets}{A logical imposing that all the network targets must
display negative logFC, i.e. logFC <= - min.t.logFC.}

\item{min.t.logFC}{The minimum log2 fold-change allowed for
targets in case pos.targets or neg.targets are used.}

\item{min.positive}{Minimum number of target genes to be found in a given
pathway.}

\item{fdr.proc}{The procedure for adjusting P-values according to
\code{\link[multtest]{mt.rawp2adjp}}.}
}
\value{
A BSRInferenceComp object. The main application of this
method is to take a "universal" inference obtained by assigning
each gene to good logFC, P-values and expression levels whose role
is to find all the reachable targets per receptor/pathway, and
to update it by using actual logFC, P-values, and expression data.
The benefit is to save time when multiple sample comparisons are
performed, only one network exploration is necessary. Note that
if a restrictive logic such as \code{positive.targets=TRUE} is used,
the result will be correct provided all the targets were in the
initial BSRInferenceComp object. If a restriction on the targets
was applied, then the update is likely to miss some targets, i.e.,
the statistical analysis will be wrong.

In case no L-R interaction is above the required thresholds, the
value `NULL` is returned.

Note that correlations are set to 1 to avoid
lengthy computations with scRNA-seq data and multiple cell
populations.

The main role of this method is to support our SingleCellSignalR v2
package.
}
\description{
A method to update the data underlying statistical significance estimations
prior to rescoring for an existing BSRInferenceComp object
(P- and Q-value estimations as well as LR-score).
}
\details{
A BSRInferenceComp object should be created by calling
\code{"\link[=BSRInferenceComp-class]{BSRInferenceComp}"}
}
\examples{
data(bsrdm.comp, package = "BulkSignalR")
data(bsrinf.comp, package = "BulkSignalR")
colA <- as.integer(1:2)
colB <- as.integer(3:4)

#bsrdm.comp <- as(bsrdm, "BSRDataModelComp")

n <- nrow(ncounts(bsrdm.comp))
stats <- data.frame(pval = runif(n),
logFC = rnorm(n, 0, 2),
expr = runif(n, 0, 10))
rownames(stats) <- rownames(ncounts(bsrdm.comp))


# update
stats$pval <- stats$pval / 100
stats$logFC <- stats$logFC + 0.5

bsrcc.2 <- BSRClusterComp(bsrdm.comp, colA, colB, stats)
bsrinf.updated <- updateInference(bsrinf.comp, bsrcc.2,
max.pval = 1, min.logFC = 0.1)
}
