% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_genes}
\alias{filter_genes}
\title{Filter a gene expression data.frame}
\usage{
filter_genes(expr, pct = 0.75, apply_vst = FALSE)
}
\arguments{
\item{expr}{A data.frame containing expression data}

\item{pct}{Percentage of most expressed genes to keep.}

\item{apply_vst}{Logical. If TRUE, will apply variance stabilizing transform
before filtering data.}
}
\value{
A data.frame containing filtered expression data
}
\description{
Filter a gene expression data.frame
}
\details{
This function takes a gene expression data.frame and applies a
percentage filter (keeps the \code{pct}) most expressed genes). If
\code{apply_vst} is TRUE, a variance stabilizing transformation is applied on
gene expression values as long as mean and variance values have a Spearman's
rho of over 0.5. This transformation is intended to remove this dependence
between the parameters. One should then apply the \code{select_genes}
function to get significant genes.
}
\examples{
# Get example expression data
data(expr0)
# Filter genes
expr_f <- filter_genes(expr0)
# Check selected genes
expr_f[1:5, 1:5]
# Filter genes and apply variance stabilizing transformation
expr_f2 <- filter_genes(expr0, apply_vst=TRUE)
# Check results
expr_f2[1:5, 1:5]
# Selected genes
selected <- select_genes(expr_f2)
# Get data.frame with only selected genes
expr_s <- expr_f2[selected, ]
# Check results
expr_s[1:5, 1:5]
}
