% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{get_phi}
\alias{get_phi}
\alias{get_phi,CEMiTool-method}
\title{Calculate phi}
\usage{
get_phi(cem, ...)

\S4method{get_phi}{CEMiTool}(cem)
}
\arguments{
\item{cem}{A CEMiTool object containing the fit_indices slot}

\item{...}{Optional parameters.}
}
\value{
The phi parameter
}
\description{
This function takes a CEMiTool object and returns the phi parameter.
}
\examples{
# Get example expression data
data(expr0)
# Initialize new CEMiTool object with expression data
cem <- new_cem(expr0, filter=TRUE, apply_vst=FALSE)
# Get modules and beta data
cem <- find_modules(cem)
# Get phi
get_phi(cem)

}
