% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_ora}
\alias{plot_ora}
\alias{plot_ora,CEMiTool-method}
\title{ORA visualization}
\usage{
plot_ora(cem, ...)

\S4method{plot_ora}{CEMiTool}(cem, n = 10, pv_cut = 0.05, ...)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{parameters to plot_ora_single}

\item{n}{number of modules to show}

\item{pv_cut}{p-value significance cutoff. Default is 0.05.}
}
\value{
Object of class \code{CEMiTool} with ORA plots
}
\description{
Creates a bar plot with the results of module overrepresentation analysis
}
\examples{
# Get example CEMiTool object
data(cem)
# Read example gmt file
gmt <- read_gmt(system.file('extdata', 'pathways.gmt',
                   package='CEMiTool'))
# Run overrepresentation analysis
cem <- mod_ora(cem, gmt)
# Plot module gene expression profiles
cem <- plot_ora(cem)
# Check resulting plot
show_plot(cem, "ora")

}
