% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/clustersDeltaExpression.R,
%   R/numericUtilities.R
\docType{class}
\name{COTAN_Legacy}
\alias{COTAN_Legacy}
\alias{scCOTAN-class}
\alias{scCotan_coerce_to_COTAN}
\alias{COTAN_coerce_to_scCOTAN}
\alias{clustersDeltaExpression}
\alias{vec2mat_rfast}
\alias{mat2vec_rfast}
\title{Handle legacy \code{scCOTAN}-class and related symmetric matrix <-> vector
conversions}
\usage{
clustersDeltaExpression(objCOTAN, clName = "", clusters = NULL)

vec2mat_rfast(x, genes = "all")

mat2vec_rfast(mat)
}
\arguments{
\item{objCOTAN}{a \code{COTAN} object}

\item{clName}{The name of the \emph{clusterization}. If not given the last
available \emph{clusterization} will be used, as it is probably the most
significant!}

\item{clusters}{A \emph{clusterization} to use. If given it will take precedence
on the one indicated by \code{clName}}

\item{x}{a \code{list} formed by two arrays: \code{genes} with the unique gene names
and \code{values} with all the values.}

\item{genes}{an array with all wanted genes or the string \code{"all"}. When equal
to \code{"all"} (the default), it recreates the entire matrix.}

\item{mat}{a square (possibly symmetric) matrix with all genes as row and
column names.}
}
\value{
a \code{scCOTAN} object

\code{clustersDeltaExpression()} returns a \code{data.frame} with the
\eqn{\nu} weighted discrepancy of the expression of each gene within the
\emph{cluster} against the corresponding model expectations

\code{mat2vec_rfast} returns a \code{list} formed by two arrays:
\itemize{
\item \code{"genes"} with the unique gene names,
\item \code{"values"} with all the values.
}

\code{vec2mat_rfast} returns the reconstructed symmetric matrix
}
\description{
A class and some functions related to the \code{V1} version of the
\code{COTAN} package
}
\details{
Define the legacy \code{scCOTAN}-class

Automatically converts an object from class \code{scCOTAN} into \code{COTAN}

Explicitly converts an object from class \code{COTAN} into \code{scCOTAN}

\code{clustersDeltaExpression()} is a legacy function now superseded by
\code{\link[=DEAOnClusters]{DEAOnClusters()}}. It estimates the change in genes' expression inside the
\emph{cluster} compared to the average situation in the data set.

This is a legacy function related to old \code{scCOTAN} objects. Use the
more appropriate \code{Matrix::dspMatrix} type for similar functionality.

\code{mat2vec_rfast} converts a compacted symmetric matrix (that is an array)
into a symmetric matrix.

This is a legacy function related to old \code{scCOTAN} objects. Use the
more appropriate \code{Matrix::dspMatrix} type for similar functionality.

\code{vec2mat_rfast} converts a symmetric matrix into a compacted symmetric
matrix. It will forcibly make its argument symmetric.
}
\section{Slots}{

\describe{
\item{\code{raw}}{\code{ANY}. To store the raw data matrix}

\item{\code{raw.norm}}{\code{ANY}. To store the raw data matrix divided for the cell
efficiency estimated (nu)}

\item{\code{coex}}{\code{ANY}. The coex matrix}

\item{\code{nu}}{\code{vector}.}

\item{\code{lambda}}{\code{vector}.}

\item{\code{a}}{\code{vector}.}

\item{\code{hk}}{\code{vector}.}

\item{\code{n_cells}}{\code{numeric}.}

\item{\code{meta}}{\code{data.frame}.}

\item{\code{yes_yes}}{\code{ANY}. Unused and deprecated. Kept for backward compatibility
only}

\item{\code{clusters}}{\code{vector}.}

\item{\code{cluster_data}}{\code{data.frame}.}
}}

\examples{
v <- list("genes" = paste0("gene_", c(1:9)), "values" = c(1:45))

M <- vec2mat_rfast(v)
all.equal(rownames(M), v[["genes"]])
all.equal(colnames(M), v[["genes"]])

genes <- paste0("gene_", sample.int(ncol(M), 3))

m <- vec2mat_rfast(v, genes)
all.equal(rownames(m), v[["genes"]])
all.equal(colnames(m), genes)

v2 <- mat2vec_rfast(M)
all.equal(v, v2)

}
