% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COTAN-getters.R, R/COTAN-modifiers.R,
%   R/calculateCoex-method.R
\name{getMu}
\alias{getMu}
\alias{calculateMu}
\alias{CalculatingCOEX}
\alias{getGenesCoex,COTAN-method}
\alias{getGenesCoex}
\alias{getCellsCoex,COTAN-method}
\alias{getCellsCoex}
\alias{isCoexAvailable,COTAN-method}
\alias{isCoexAvailable}
\alias{dropGenesCoex,COTAN-method}
\alias{dropGenesCoex}
\alias{dropCellsCoex,COTAN-method}
\alias{dropCellsCoex}
\alias{calculateLikelihoodOfObserved}
\alias{observedContingencyTablesYY}
\alias{observedPartialContingencyTablesYY}
\alias{observedContingencyTables}
\alias{observedPartialContingencyTables}
\alias{expectedContingencyTablesNN}
\alias{expectedPartialContingencyTablesNN}
\alias{expectedContingencyTables}
\alias{expectedPartialContingencyTables}
\alias{contingencyTables}
\alias{calculateCoex,COTAN-method}
\alias{calculateCoex}
\alias{calculatePartialCoex}
\alias{calculateS}
\alias{calculateG}
\title{Calculating the COEX matrix for genes and cells}
\usage{
getMu(objCOTAN)

\S4method{getGenesCoex}{COTAN}(
  objCOTAN,
  genes = vector(mode = "character"),
  zeroDiagonal = TRUE,
  ignoreSync = FALSE
)

\S4method{getCellsCoex}{COTAN}(
  objCOTAN,
  cells = vector(mode = "character"),
  zeroDiagonal = TRUE,
  ignoreSync = FALSE
)

\S4method{isCoexAvailable}{COTAN}(objCOTAN, actOnCells = FALSE, ignoreSync = FALSE)

\S4method{dropGenesCoex}{COTAN}(objCOTAN)

\S4method{dropCellsCoex}{COTAN}(objCOTAN)

calculateLikelihoodOfObserved(objCOTAN)

observedContingencyTablesYY(
  objCOTAN,
  actOnCells = FALSE,
  asDspMatrices = FALSE
)

observedPartialContingencyTablesYY(
  objCOTAN,
  columnsSubset,
  zeroOne = NULL,
  actOnCells = FALSE
)

observedContingencyTables(objCOTAN, actOnCells = FALSE, asDspMatrices = FALSE)

observedPartialContingencyTables(
  objCOTAN,
  columnsSubset,
  zeroOne = NULL,
  actOnCells = FALSE
)

expectedContingencyTablesNN(
  objCOTAN,
  actOnCells = FALSE,
  asDspMatrices = FALSE,
  optimizeForSpeed = TRUE
)

expectedPartialContingencyTablesNN(
  objCOTAN,
  columnsSubset,
  probZero = NULL,
  actOnCells = FALSE,
  optimizeForSpeed = TRUE
)

expectedContingencyTables(
  objCOTAN,
  actOnCells = FALSE,
  asDspMatrices = FALSE,
  optimizeForSpeed = TRUE
)

expectedPartialContingencyTables(
  objCOTAN,
  columnsSubset,
  probZero = NULL,
  actOnCells = FALSE,
  optimizeForSpeed = TRUE
)

contingencyTables(objCOTAN, g1, g2)

\S4method{calculateCoex}{COTAN}(
  objCOTAN,
  actOnCells = FALSE,
  returnPPFract = FALSE,
  optimizeForSpeed = TRUE,
  deviceStr = "cuda"
)

calculatePartialCoex(
  objCOTAN,
  columnsSubset,
  probZero = NULL,
  zeroOne = NULL,
  actOnCells = FALSE,
  optimizeForSpeed = TRUE
)

calculateS(
  objCOTAN,
  geneSubsetCol = vector(mode = "character"),
  geneSubsetRow = vector(mode = "character")
)

calculateG(
  objCOTAN,
  geneSubsetCol = vector(mode = "character"),
  geneSubsetRow = vector(mode = "character")
)
}
\arguments{
\item{objCOTAN}{a \code{COTAN} object}

\item{genes}{The given genes' names to select the wanted \code{COEX} columns. If
missing all columns will be returned. When not empty a proper result is
provided by calculating the partial \code{COEX} matrix on the fly}

\item{zeroDiagonal}{When \code{TRUE} sets the diagonal to zero.}

\item{ignoreSync}{When \code{TRUE} ignores whether the \code{lambda}/\code{nu}/\code{dispersion}
have been updated since the \code{COEX} matrix was calculated.}

\item{cells}{The given cells' names to select the wanted \code{COEX} columns. If
missing all columns will be returned. When not empty a proper result is
provided by calculating the partial \code{COEX} matrix on the fly}

\item{actOnCells}{Boolean; when \code{TRUE} the function works for the cells,
otherwise for the genes}

\item{asDspMatrices}{Boolean; when \code{TRUE} the function will return only
packed dense symmetric matrices}

\item{columnsSubset}{a sub-set of the columns of the matrices that will be
returned}

\item{zeroOne}{the raw count matrix projected to \code{0} or \code{1}. If not given the
appropriate one will be calculated on the fly}

\item{optimizeForSpeed}{Boolean; deprecated: always TRUE}

\item{probZero}{is the expected \strong{probability of zero} for each gene/cell
pair. If not given the appropriate one will be calculated on the fly}

\item{g1}{a gene}

\item{g2}{another gene}

\item{returnPPFract}{Boolean; when \code{TRUE} the function returns the fraction
of genes/cells pairs for which the \emph{expected contingency table} is smaller
than \eqn{0.5}. Default is FALSE}

\item{deviceStr}{On the \code{torch} library enforces which device to use to run
the calculations. Possible values are \code{"cpu"} to us the system \emph{CPU},
\code{"cuda"} to use the system \emph{GPUs} or something like \code{"cuda:0"} to restrict
to a specific device}

\item{geneSubsetCol}{an array of genes. It will be put in columns. If left
empty the function will do it genome-wide.}

\item{geneSubsetRow}{an array of genes. It will be put in rows. If left empty
the function will do it genome-wide.}
}
\value{
\code{getMu()} returns the \code{mu} matrix

\code{getGenesCoex()} returns the genes' \code{COEX} values

\code{getCellsCoex()} returns the cells' \code{COEX} values

\code{isCoexAvailable()} returns whether relevant \code{COEX} matrix has been
calculated and, in case, if it is still aligned to the estimators.

\code{dropGenesCoex()} returns the updated \code{COTAN} object

\code{dropCellsCoex()} returns the updated \code{COTAN} object

\code{calculateLikelihoodOfObserved()} returns a \code{data.frame} with the
likelihood of the observed zero/one

\code{observedContingencyTablesYY()} returns a \code{list} with:
\itemize{
\item \code{observedYY} the \emph{Yes/Yes} observed contingency table as \code{matrix}
\item \code{observedY}  the full \emph{Yes} observed \code{vector}
}

\code{observedPartialContingencyTablesYY()} returns a \code{list} with:
\itemize{
\item \code{observedYY} the \emph{Yes/Yes} observed contingency table as \code{matrix},
restricted to the selected columns as named \code{list} with elements
\item \code{observedY}  the full \emph{Yes} observed \code{vector}
}

\code{observedContingencyTables()} returns the observed contingency
tables as named \code{list} with elements:
\itemize{
\item \code{"observedNN"}
\item \code{"observedNY"}
\item \code{"observedYN"}
\item \code{"observedYY"}
}

\code{observedPartialContingencyTables()} returns the observed
contingency tables, restricted to the selected columns, as named \code{list}
with elements:
\itemize{
\item \code{"observedNN"}
\item \code{"observedNY"}
\item \code{"observedYN"}
\item \code{"observedYY"}
}

\code{expectedContingencyTablesNN()} returns a \code{list} with:
\itemize{
\item \code{expectedNN} the \emph{No/No} expected contingency table as \code{matrix}
\item \code{expectedN}  the \emph{No} expected \code{vector}
}

\code{expectedPartialContingencyTablesNN()} returns a \code{list} with:
\itemize{
\item \code{expectedNN} the \emph{No/No} expected contingency table as \code{matrix},
restricted to the selected columns, as named \code{list} with elements
\item \code{expectedN}  the full \emph{No} expected \code{vector}
}

\code{expectedContingencyTables()} returns the expected contingency tables
as named \code{list} with elements:
\itemize{
\item \code{"expectedNN"}
\item \code{"expectedNY"}
\item \code{"expectedYN"}
\item \code{"expectedYY"}
}

\code{expectedPartialContingencyTables()} returns the expected contingency
tables, restricted to the selected columns, as named \code{list} with elements:
\itemize{
\item \code{"expectedNN"}
\item \code{"expectedNY"}
\item \code{"expectedYN"}
\item \code{"expectedYY"}
}

\code{contingencyTables()} returns a list containing the observed and
expected contingency tables

\code{calculateCoex()} returns the updated \code{COTAN} object

\code{calculatePartialCoex()} returns the asked section of the \code{COEX}
matrix

\code{calculateS()} returns the \code{S} matrix

\code{calculateG()} returns the G matrix
}
\description{
These are the functions and methods used to calculate the
\strong{COEX} matrices according to the \code{COTAN} model. From there it is possible
to calculate the associated \emph{pValue} and the \emph{GDI} (\emph{Global Differential
Expression})

The \strong{COEX} matrix is defined by following formula:

\deqn{\frac{\sum_{i,j \in \{\text{Y, N}\}}{
                    (-1)^{\#\{i,j\}}\frac{O_{ij}-E_{ij}}{1 \vee E_{ij}}}}
             {\sqrt{n \sum_{i,j \in \{\text{Y, N}\}}{
                            \frac{1}{1 \vee E_{ij}}}}}}

where \eqn{O} and \eqn{E} are the observed and expected contingency tables
and \eqn{n} is the relevant numerosity (the number of genes/cells depending
on given \code{actOnCells} flag).

The formula can be more effectively implemented as:

\deqn{\sqrt{\frac{1}{n}\sum_{i,j \in \{\text{Y, N}\}}{
                               \frac{1}{1 \vee E_{ij}}}}
        \, \bigl(O_\text{YY}-E_\text{YY}\bigr)}

once one notices that \eqn{O_{ij} - E_{ij} = (-1)^{\#\{i,j\}} \, r} for
some constant \eqn{r} for all \eqn{i,j \in \{\text{Y, N}\}}.

The latter follows from the fact that the relevant marginal sums of the
expected contingency tables were enforced to match the marginal sums of the
observed ones.

The new implementation of the function relies on the \code{torch}
package. This implies that it is potentially able to use the system \code{GPU}
to run the heavy duty calculations required by this method. However
installing the \code{torch} package on a system can be \emph{finicky}, so we
tentatively provide a short help page \link{Installing_torch} hoping that it
will help...
}
\details{
\code{getMu()} calculates the vector \eqn{\mu = \lambda \times
  \nu^T}

\code{getGenesCoex()} extracts a complete (or a partial after genes
dropping) genes' \code{COEX} matrix from the \code{COTAN} object.

\code{getCellsCoex()} extracts a complete (or a partial after cells
dropping) cells' \code{COEX} matrix from the \code{COTAN} object.

\code{isCoexAvailable()} allows to query whether the relevant \code{COEX}
matrix from the \code{COTAN} object is available to use

\code{dropGenesCoex()} drops the \code{genesCoex} member from the given
\code{COTAN} object

\code{dropCellsCoex()} drops the \code{cellsCoex} member from the given
\code{COTAN} object

\code{calculateLikelihoodOfObserved()} gives for each cell and each gene
the likelihood of the observed zero/one data

\code{observedContingencyTablesYY()} calculates observed \emph{Yes/Yes} field
of the contingency table

\code{observedPartialContingencyTablesYY()} calculates observed \emph{Yes/Yes}
field of the contingency table

\code{observedContingencyTables()} calculates the observed contingency
tables. When the parameter \code{asDspMatrices == TRUE}, the method will
effectively throw away the lower half from the returned \code{observedYN} and
\code{observedNY} matrices, but, since they are transpose one of another, the
full information is still available.

\code{observedPartialContingencyTables()} calculates the observed
contingency tables.

\code{expectedContingencyTablesNN()} calculates the expected \emph{No/No}
field of the contingency table

\code{expectedPartialContingencyTablesNN()} calculates the expected
\emph{No/No} field of the contingency table

\code{expectedContingencyTables()} calculates the expected values of
contingency tables. When the parameter \code{asDspMatrices == TRUE}, the method
will effectively throw away the lower half from the returned \code{expectedYN}
and \code{expectedNY} matrices, but, since they are transpose one of another,
the full information is still available.

\code{expectedPartialContingencyTables()} calculates the expected values
of contingency tables, restricted to the specified column sub-set

\code{contingencyTables()} returns the observed and expected contingency
tables for a given pair of genes. The implementation runs the same
algorithms used to calculate the full observed/expected contingency tables,
but restricted to only the relevant genes and thus much faster and less
memory intensive

\code{calculateCoex()} estimates and stores the \code{COEX} matrix in the
\code{cellCoex} or \code{genesCoex} field depending on given \code{actOnCells} flag. It
also calculates the percentage of \emph{problematic} genes/cells pairs. A pair
is \emph{problematic} when one or more of the expected counts were significantly
smaller than 1 (\eqn{< 0.5}). These small expected values signal that scant
information is present for such a pair.

\code{calculatePartialCoex()} estimates a sub-section of the \code{COEX}
matrix in the \code{cellCoex} or \code{genesCoex} field depending on given
\code{actOnCells} flag. It also calculates the percentage of \emph{problematic}
genes/cells pairs. A pair is \emph{problematic} when one or more of the expected
counts were significantly smaller than 1 (\eqn{< 0.5}). These small
expected values signal that scant information is present for such a pair.

\code{calculateS()} calculates the statistics \strong{S} for genes contingency
tables. It always has the diagonal set to zero.

\code{calculateG()} calculates the statistics \emph{G-test} for genes
contingency tables. It always has the diagonal set to zero. It is
proportional to the genes' presence mutual information.
}
\note{
The sum of the matrices returned by the function
\code{observedContingencyTables()} and \code{expectedContingencyTables()} will have
the same value on all elements. This value is the number of genes/cells
depending on the parameter \code{actOnCells} being \code{TRUE/FALSE}.
}
\examples{
data("test.dataset")
objCOTAN <- COTAN(raw = test.dataset)
objCOTAN <- initializeMetaDataset(objCOTAN, GEO = "test_GEO",
                                  sequencingMethod = "distribution_sampling",
                                  sampleCondition = "reconstructed_dataset")
objCOTAN <- clean(objCOTAN)

objCOTAN <- estimateDispersionBisection(objCOTAN, cores = 6L)

## Now the `COTAN` object is ready to calculate the genes' `COEX`

## mu <- getMu(objCOTAN)
## observedY <- observedContingencyTablesYY(objCOTAN, asDspMatrices = TRUE)
obs <- observedContingencyTables(objCOTAN, asDspMatrices = TRUE)

## expectedN <- expectedContingencyTablesNN(objCOTAN, asDspMatrices = TRUE)
exp <- expectedContingencyTables(objCOTAN, asDspMatrices = TRUE)

objCOTAN <- calculateCoex(objCOTAN, actOnCells = FALSE)

stopifnot(isCoexAvailable(objCOTAN))
genesCoex <- getGenesCoex(objCOTAN)
genesSample <- sample(getNumGenes(objCOTAN), 10)
partialGenesCoex <- calculatePartialCoex(objCOTAN, genesSample,
                                         actOnCells = FALSE)

identical(partialGenesCoex,
          getGenesCoex(objCOTAN, getGenes(objCOTAN)[sort(genesSample)]))

## S <- calculateS(objCOTAN)
## G <- calculateG(objCOTAN)
## pValue <- calculatePValue(objCOTAN)
gdiDF <- calculateGDI(objCOTAN)
objCOTAN <- storeGDI(objCOTAN, genesGDI = gdiDF)

## Touching any of the lambda/nu/dispersino parameters invalidates the `COEX`
## matrix and derivatives, so it can be dropped it from the `COTAN` object
objCOTAN <- dropGenesCoex(objCOTAN)
stopifnot(!isCoexAvailable(objCOTAN))


objCOTAN <- estimateDispersionNuBisection(objCOTAN, cores = 6L)

## Now the `COTAN` object is ready to calculate the cells' `COEX`
## In case one need to caclualte both it is more sensible to run the above
## before any `COEX` evaluation

g1 <- getGenes(objCOTAN)[sample(getNumGenes(objCOTAN), 1)]
g2 <- getGenes(objCOTAN)[sample(getNumGenes(objCOTAN), 1)]
tables <- contingencyTables(objCOTAN, g1 = g1, g2 = g2)
tables

objCOTAN <- calculateCoex(objCOTAN, actOnCells = TRUE)
stopifnot(isCoexAvailable(objCOTAN, actOnCells = TRUE, ignoreSync = TRUE))
cellsCoex <- getCellsCoex(objCOTAN)

cellsSample <- sample(getNumCells(objCOTAN), 10)
partialCellsCoex <- calculatePartialCoex(objCOTAN, cellsSample,
                                         actOnCells = TRUE)

identical(partialCellsCoex, cellsCoex[, sort(cellsSample)])

objCOTAN <- dropCellsCoex(objCOTAN)
stopifnot(!isCoexAvailable(objCOTAN, actOnCells = TRUE))

lh <- calculateLikelihoodOfObserved(objCOTAN)

}
\seealso{
\link{ParametersEstimations} for more details.

\link{Installing_torch} about the \code{torch} package
}
