% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Datasets}
\alias{Datasets}
\alias{raw.dataset}
\alias{ERCCraw}
\alias{test.dataset}
\alias{test.dataset.clusters1}
\alias{test.dataset.clusters2}
\alias{vignette.split.clusters}
\alias{vignette.merge.clusters}
\alias{vignette.merge2.clusters}
\title{Data-sets}
\format{
\code{raw.dataset} is a data frame with \eqn{2000} genes and \eqn{815}
cells

\code{ERCCRaw} is a \code{data.frame}

\code{test.dataset} is a \code{data.frame} with \eqn{600} genes and \eqn{1200}
cells

\code{test.dataset.clusters1} is a \verb{character array}

\code{test.dataset.clusters2} is a \verb{character array}

\code{vignette.split.clusters} is a \code{factor}

\code{vignette.merge.clusters} is a \code{factor}

\code{vignette.merge2.clusters} is a \code{factor}
}
\source{
GEO GSM2861514

ERCC
}
\usage{
data(raw.dataset)

data(ERCCraw)

data(test.dataset)

data(test.dataset.clusters1)

data(test.dataset.clusters2)

data(vignette.split.clusters)

data(vignette.merge.clusters)

data(vignette.merge2.clusters)
}
\description{
Simple data-sets included in the package
}
\details{
\code{raw.dataset} is a sub-sample of a real \emph{scRNA-seq} data-set

\code{ERCCRaw} dataset

\code{test.dataset} is an artificial data set obtained by sampling target
negative binomial distributions on a set of \eqn{600} genes on \eqn{2} two
cells \emph{clusters} of \eqn{600} cells each. Each \emph{clusters} has its own set
of parameters for the distributions even, but a fraction of the genes has
the same expression in both \emph{clusters}.

\code{test.dataset.clusters1} is the \emph{clusterization} obtained running
\code{cellsUniformClustering()} on the \code{test.dataset}

\code{test.dataset.clusters2} is the \emph{clusterization} obtained running
\code{mergeUniformCellsClusters()} on the \code{test.dataset} using the previous
\emph{clusterization}

\code{vignette.split.clusters} is the clusterization obtained running
\code{cellsUniformClustering()} on the vignette dataset (mouse cortex E17.5,
GEO: GSM2861514)

\code{vignette.merge.clusters} is the clusterization obtained running
\code{mergeUniformCellsClusters()} on the vignette dataset (mouse cortex E17.5,
GEO: GSM2861514) using the previous \emph{clusterization}

\code{vignette.merge2.clusters} is the clusterization obtained re-running
\code{mergeUniformCellsClusters()} on the vignette dataset (mouse cortex E17.5,
GEO: GSM2861514) using the \code{vignette.split.clusters} \emph{clusterization}, but
with a sequence of progressively relaxed checks
}
\keyword{datasets}
