% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COTAN-getters.R, R/COTAN-modifiers.R,
%   R/utilities.R
\name{HandleMetaData}
\alias{HandleMetaData}
\alias{getMetadataDataset,COTAN-method}
\alias{getMetadataDataset}
\alias{getMetadataElement,COTAN-method}
\alias{getMetadataElement}
\alias{getMetadataGenes,COTAN-method}
\alias{getMetadataGenes}
\alias{getMetadataCells,COTAN-method}
\alias{getMetadataCells}
\alias{getDims,COTAN-method}
\alias{getDims}
\alias{datasetTags}
\alias{initializeMetaDataset,COTAN-method}
\alias{initializeMetaDataset}
\alias{addElementToMetaDataset,COTAN-method}
\alias{addElementToMetaDataset}
\alias{getColumnFromDF}
\alias{setColumnInDF}
\title{Handling \emph{meta-data} in \code{COTAN} objects}
\usage{
\S4method{getMetadataDataset}{COTAN}(objCOTAN)

\S4method{getMetadataElement}{COTAN}(objCOTAN, tag)

\S4method{getMetadataGenes}{COTAN}(objCOTAN)

\S4method{getMetadataCells}{COTAN}(objCOTAN)

\S4method{getDims}{COTAN}(objCOTAN)

datasetTags()

\S4method{initializeMetaDataset}{COTAN}(objCOTAN, GEO, sequencingMethod, sampleCondition)

\S4method{addElementToMetaDataset}{COTAN}(objCOTAN, tag, value)

getColumnFromDF(df, colName)

setColumnInDF(df, colToSet, colName, rowNames = vector(mode = "character"))
}
\arguments{
\item{objCOTAN}{a \code{COTAN} object}

\item{tag}{the new information tag}

\item{GEO}{a code reporting the GEO identification or other specific data-set
code}

\item{sequencingMethod}{a string reporting the method used for the sequencing}

\item{sampleCondition}{a string reporting the specific sample condition or
time point}

\item{value}{a value (or an array) containing the information}

\item{df}{the \code{data.frame}}

\item{colName}{the name of the new or existing column in the \code{data.frame}}

\item{colToSet}{the column to add}

\item{rowNames}{when not empty, if the input \code{data.frame} has no real row
names, the new row names of the resulting \code{data.frame}}
}
\value{
\code{getMetadataDataset()} returns the meta-data \code{data.frame}

\code{getMetadataElement()} returns a string with the relevant value

\code{getMetadataGenes()} returns the genes' meta-data \code{data.frame}

\code{getMetadataCells()} returns the cells' meta-data \code{data.frame}

\code{getDims()} returns a named \code{list} with the sizes of the slots

\code{datasetTags()} a named \verb{character array} with the standard labels
used in the \code{metaDataset} of the \code{COTAN} objects

\code{initializeMetaDataset()} returns the given \code{COTAN} object with the
updated \code{metaDataset}

\code{addElementToMetaDataset()} returns the updated \code{COTAN} object

\code{getColumnFromDF()} returns the column in the \code{data.frame} as named
\code{array}, \code{NULL} if the wanted column is not available

\code{setColumnInDF()} returns the updated, or the newly created,
\code{data.frame}
}
\description{
Much of the information stored in the \code{COTAN} object is
compacted into three \code{data.frame}s:
\itemize{
\item \code{"metaDataset"} - contains all general information about the data-set
\item \code{"metaGenes"} - contains genes' related information along the \code{lambda}
and \code{dispersion} vectors and the fully-expressed flag
\item \code{"metaCells"} - contains cells' related information along the \code{nu}
vector, the fully-expressing flag, the \emph{clusterizations} and the
\emph{conditions}
}
}
\details{
\code{getMetadataDataset()} extracts the meta-data stored for the
current data-set.

\code{getMetadataElement()} extracts the value associated with the
given tag if present or an empty string otherwise.

\code{getMetadataGenes()} extracts the meta-data stored for the genes

\code{getMetadataCells()} extracts the meta-data stored for the cells

\code{getDims()} extracts the sizes of all slots of the \code{COTAN} object

\code{datasetTags()} defines a list of short names associated to an
enumeration. It also defines the relative long names as they appear in the
meta-data

\code{initializeMetaDataset()} initializes meta-data data-set

\code{addElementToMetaDataset()} is used to add a line of information to
the meta-data \code{data.frame}. If the tag was already used it will update the
associated value(s) instead

\code{getColumnFromDF()} is a function to extract a column from a
\code{data.frame}, while keeping the \code{rowNames} as \code{vector} names

\code{setColumnInDF()} is a function to append, if missing, or resets, if
present, a column into a \code{data.frame}, whether the \code{data.frame} is empty or
not. The given \code{rowNames} are used only in the case the \code{data.frame} has
only the default row numbers, so this function cannot be used to override
row names
}
\examples{
data("test.dataset")
objCOTAN <- COTAN(raw = test.dataset)

objCOTAN <- initializeMetaDataset(objCOTAN, GEO = "test_GEO",
                                  sequencingMethod = "distribution_sampling",
                                  sampleCondition = "reconstructed_dataset")

objCOTAN <- addElementToMetaDataset(objCOTAN, "Test",
                                    c("These are ", "some values"))

dataSetInfo <- getMetadataDataset(objCOTAN)

numInitialCells <- getMetadataElement(objCOTAN, "cells")

metaGenes <- getMetadataGenes(objCOTAN)

metaCells <- getMetadataCells(objCOTAN)

allSizes <- getDims(objCOTAN)

}
