% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap-plot.R, R/utilities.R
\name{HeatmapPlots}
\alias{HeatmapPlots}
\alias{singleHeatmapDF}
\alias{heatmapPlot}
\alias{genesHeatmapPlot}
\alias{cellsHeatmapPlot}
\alias{plotTheme}
\title{Heatmap Plots}
\usage{
singleHeatmapDF(objCOTAN, genesLists, sets, pValueThreshold = 0.01)

heatmapPlot(
  objCOTAN = NULL,
  genesLists,
  sets = NULL,
  pValueThreshold = 0.01,
  conditions = NULL,
  dir = "."
)

genesHeatmapPlot(
  objCOTAN,
  primaryMarkers,
  secondaryMarkers = vector(mode = "character"),
  pValueThreshold = 0.01,
  symmetric = TRUE
)

cellsHeatmapPlot(objCOTAN, cells = NULL, clusters = NULL)

plotTheme(plotKind = "common", textSize = 14L)
}
\arguments{
\item{objCOTAN}{a \code{COTAN} object}

\item{genesLists}{A \code{list} of genes' \code{array}s. The first \code{array} defines the
genes in the columns}

\item{sets}{A numeric array indicating which fields in the previous \code{list}
should be used. Defaults to all fields}

\item{pValueThreshold}{The p-value threshold. Default is 0.01}

\item{conditions}{An \code{array} of prefixes indicating the different files}

\item{dir}{The directory in which are all \code{COTAN} files (corresponding to the
previous prefixes)}

\item{primaryMarkers}{A set of genes plotted as rows}

\item{secondaryMarkers}{A set of genes plotted as columns}

\item{symmetric}{A Boolean: default \code{TRUE}. When \code{TRUE} the union of
\code{primaryMarkers} and \code{secondaryMarkers} is used for both rows and column
genes}

\item{cells}{Which cells to plot (all if no argument is given)}

\item{clusters}{Use this clusterization to select/reorder the cells to plot}

\item{plotKind}{a string indicating the plot kind}

\item{textSize}{axes and strip text size (default=14)}
}
\value{
\code{singleHeatmapDF()} returns a \code{data.frame}

\code{heatmapPlot()} returns a \code{ggplot2} object

\code{genesHeatmapPlot()} returns a \code{ggplot2} object

\code{cellsHeatmapPlot()} returns the cells' \code{COEX} \emph{heatmap} plot

\code{plotTheme()} returns a \code{ggplot2::theme} object
}
\description{
These functions create heatmap \code{COEX} plots.
}
\details{
\code{singleHeatmapDF()} creates the \code{heatmap} \code{data.frame} of one
\code{COTAN} object

\code{heatmapPlot()} creates the \code{heatmap} of one or more \code{COTAN} objects

\code{genesHeatmapPlot()} is used to plot an \emph{heatmap} made using only
some genes, as markers, and collecting all other genes correlated with
these markers with a p-value smaller than the set threshold. Than all
relations are plotted. Primary markers will be plotted as groups of rows.
Markers list will be plotted as columns.

\code{cellsHeatmapPlot()} creates the heatmap plot of the cells' \code{COEX}
matrix

\code{plotTheme()} returns the appropriate theme for the selected plot
kind. Supported kinds are:  \code{"common"}, \code{"pca"}, \code{"genes"}, \code{"UDE"},
\code{"heatmap"}, \code{"GDI"}, \code{"UMAP"}, \code{"size-plot"}
}
\examples{
data("test.dataset")
objCOTAN <- COTAN(raw = test.dataset)
objCOTAN <- clean(objCOTAN)
objCOTAN <- estimateDispersionNuBisection(objCOTAN, cores = 6L)
objCOTAN <- calculateCoex(objCOTAN, actOnCells = FALSE)
objCOTAN <- calculateCoex(objCOTAN, actOnCells = TRUE)

## some genes
primaryMarkers <- c("g-000010", "g-000020", "g-000030")

## an example of named list of different gene set
groupMarkers <- list(G1 = primaryMarkers,
                     G2 = c("g-000300", "g-000330"),
                     G3 = c("g-000510", "g-000530", "g-000550",
                            "g-000570", "g-000590"))

hPlot <- heatmapPlot(objCOTAN, pValueThreshold = 0.05,
                     genesLists = groupMarkers, sets = 2L:3L)
plot(hPlot)

ghPlot <- genesHeatmapPlot(objCOTAN, primaryMarkers = primaryMarkers,
                           secondaryMarkers = groupMarkers,
                           pValueThreshold = 0.05, symmetric = FALSE)
plot(ghPlot)

clusters <- c(rep_len("1", getNumCells(objCOTAN)/2),
              rep_len("2", getNumCells(objCOTAN)/2))
names(clusters) <- getCells(objCOTAN)

chPlot <- cellsHeatmapPlot(objCOTAN, clusters = clusters)
## plot(chPlot)

theme <- plotTheme("pca")

}
\seealso{
\code{\link[ggplot2:theme]{ggplot2::theme()}} and \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
