% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericUtilities.R
\name{NumericUtilities}
\alias{NumericUtilities}
\alias{funProbZero}
\alias{dispersionBisection}
\alias{parallelDispersionBisection}
\alias{nuBisection}
\alias{parallelNuBisection}
\alias{calcDist}
\title{Numeric Utilities}
\usage{
funProbZero(dispersion, mu)

dispersionBisection(
  sumZeros,
  lambda,
  nu,
  threshold = 0.001,
  maxIterations = 100L
)

parallelDispersionBisection(
  genes,
  sumZeros,
  lambda,
  nu,
  threshold = 0.001,
  maxIterations = 100L
)

nuBisection(
  sumZeros,
  lambda,
  dispersion,
  initialGuess,
  threshold = 0.001,
  maxIterations = 100L
)

parallelNuBisection(
  cells,
  sumZeros,
  lambda,
  dispersion,
  initialGuess,
  threshold = 0.001,
  maxIterations = 100L
)

calcDist(data, method, diag = FALSE, upper = FALSE)
}
\arguments{
\item{dispersion}{the estimated \code{dispersion} (a \eqn{n}-sized vector)}

\item{mu}{the \code{lambda} times \code{nu} values (a \eqn{n \times m} matrix)}

\item{sumZeros}{the number of genes not expressed in the relevant cell (a
\eqn{m}-sized vector)}

\item{lambda}{the estimated \code{lambda} (a \eqn{n}-sized vector)}

\item{nu}{the estimated \code{nu} (a \eqn{m}-sized vector)}

\item{threshold}{minimal solution precision}

\item{maxIterations}{max number of iterations (avoids infinite loops)}

\item{genes}{names of the relevant genes}

\item{initialGuess}{the initial guess for \code{nu}  (a \eqn{m}-sized vector)}

\item{cells}{names of the relevant cells}

\item{data}{a matrix or a data.frame of which we want to calculate the
distance between columns}

\item{method}{type of distance to use. Can be chosen among those supported by
\code{\link[parallelDist:parDist]{parallelDist::parDist()}}}

\item{diag}{logical value indicating whether the diagonal of the distance
matrix should be printed by print.dist.upper}

\item{upper}{logical value indicating whether the upper triangle of the
distance matrix should be printed by print.dist}
}
\value{
the probability \code{matrix} that a \emph{read count} is identically zero

the dispersion value

the dispersion values

the nu value

the dispersion values

a \code{dist} object with all distances
}
\description{
A set of function helper related to the statistical model
underlying the \code{COTAN} package
}
\details{
\code{funProbZero} is a private function that gives the probability that
a sample gene's reads are zero, given the \code{dispersion} and \code{mu} parameters.

Using \eqn{d}{`disp`} for \code{disp} and \eqn{\mu}{`mu`} for \code{mu},
it returns:
\eqn{(1 + d \mu)^{-\frac{1}{d}}}{(1 + `disp` * `mu`)^(-1 / `disp`)}
when \eqn{d > 0}{`disp > 0`} and
\eqn{\exp{((d - 1) \mu)}}{exp((`disp` - 1) * `mu`)} otherwise.
The function is continuous in \eqn{d = 0}{`disp = 0`},
increasing in \eqn{d}{`disp`} and decreasing in \eqn{\mu}{`mu`}.
It returns 0 when \eqn{d = -\infty}{`disp = -Inf`} or
\eqn{\mu = \infty}{`mu = Inf`}.
It returns 1 when \eqn{\mu = 0}{`mu = 0`}.

\code{dispersionBisection} is a private function for the estimation of
\emph{dispersion} slot of a \code{COTAN} object via a bisection solver

The goal is to find a \code{dispersion} value that reduces to zero the
difference between the number of estimated and counted zeros

\code{parallelDispersionBisection} is a private function invoked by
\code{\link[=estimateDispersionBisection]{estimateDispersionBisection()}} for the estimation of the \code{dispersion} slot
of a \code{COTAN} object via a parallel bisection solver

The goal is to find a \verb{dispersion array} that reduces to zero the
difference between the number of estimated and counted zeros

\code{nuBisection} is a private function for the estimation of \code{nu} slot
of a \code{COTAN} object via a bisection solver

The goal is to find a \code{nu} value that reduces to zero the difference
between the number of estimated and counted zeros

\code{parallelNuBisection} is a private function invoked by
\code{\link[=estimateNuBisection]{estimateNuBisection()}} for the estimation of \code{nu} slot of a \code{COTAN} object
via a parallel bisection solver

The goal is to find a \verb{nu array} that reduces to zero the difference
between the number of estimated and counted zeros

\code{calcDist} is a wrapper function that invokes
\code{\link[parallelDist:parDist]{parallelDist::parDist()}}: the main goal is to recover and finish the
calculations via a fallback when there is a problem with the main algorithm
}
